/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.PunisherItemRenderer;
import destiny.armoryofdestiny.server.item.utility.TooltipSwordItem;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PunisherItem
extends TooltipSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String ANIMATION_TICK = "animationTick";
    public static final String STRIKES_REMAINING = "strikesRemaining";
    public static final UUID ABILITY_MULTIPLIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A23DB5CF");
    private float attackDamage = 17.0f;
    private double attackSpeed = -3.2f;
    private double attackKnockback = -1.2f;
    public float attackDamageAbility = 7.0f;
    public double attackSpeedAbility = 0.8;
    public double attackKnockbackAbility = 2.8;

    public PunisherItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private PunisherItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PunisherItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.STOP)});
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (stack.m_41783_() != null && stack.m_41784_().m_128451_(STRIKES_REMAINING) > 0) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackDamageAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", this.attackSpeedAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", this.attackKnockbackAbility, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackKnockback, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21205_().m_41720_() == ItemRegistry.PUNISHER.get()) {
            if (stack.m_41784_().m_128451_(STRIKES_REMAINING) <= 0) {
                stack.m_41784_().m_128405_(STRIKES_REMAINING, 3);
                stack.m_41784_().m_128405_(ANIMATION_TICK, 1);
                level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.PUNISHER_ACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity1, LivingEntity entity2) {
        stack.m_41622_(1, entity2, entity3 -> entity3.m_21166_(EquipmentSlot.MAINHAND));
        if (stack.m_41783_() != null) {
            int strikesRemaining = stack.m_41784_().m_128451_(STRIKES_REMAINING);
            if (strikesRemaining > 1) {
                entity1.m_5496_((SoundEvent)SoundRegistry.PUNISHER_ATTACK.get(), 1.0f, 1.0f);
                stack.m_41784_().m_128405_(STRIKES_REMAINING, strikesRemaining - 1);
            } else if (strikesRemaining == 1) {
                entity1.m_5496_((SoundEvent)SoundRegistry.PUNISHER_ATTACK.get(), 1.0f, 1.0f);
                entity1.m_5496_((SoundEvent)SoundRegistry.PUNISHER_DEACTIVATE.get(), 1.0f, 1.0f);
                stack.m_41784_().m_128405_(STRIKES_REMAINING, 0);
            }
        }
        return true;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean b) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41783_() != null) {
                int strikesRemaining = stack.m_41784_().m_128451_(STRIKES_REMAINING);
                int animationTick = stack.m_41784_().m_128451_(ANIMATION_TICK);
                if (strikesRemaining > 0) {
                    if (animationTick > 0) {
                        stack.m_41784_().m_128405_(ANIMATION_TICK, animationTick + 1);
                    }
                    if (animationTick == 8) {
                        stack.m_41784_().m_128405_(ANIMATION_TICK, 1);
                    }
                } else if (animationTick > 0) {
                    stack.m_41784_().m_128405_(ANIMATION_TICK, 0);
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_(Items.f_42415_);
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.hammer";
    }
}

