/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.registry;

import destiny.armoryofdestiny.server.block.ArmorersAnvilBlock;
import destiny.armoryofdestiny.server.block.ArmorersCraftingTableBlock;
import destiny.armoryofdestiny.server.block.ArmorersTinkeringTableBlock;
import destiny.armoryofdestiny.server.block.BloomeryBottomBlock;
import destiny.armoryofdestiny.server.block.BloomeryTopBlock;
import destiny.armoryofdestiny.server.block.HotBlock;
import destiny.armoryofdestiny.server.block.HotChainBlock;
import destiny.armoryofdestiny.server.block.HotIronBarsBlock;
import destiny.armoryofdestiny.server.block.NetherBloomeryBottomBlock;
import destiny.armoryofdestiny.server.block.NetherBloomeryTopBlock;
import destiny.armoryofdestiny.server.block.TemperingBarrelBlock;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"armoryofdestiny");
    public static final RegistryObject<Block> ARMORERS_CRAFTING_TABLE = BlockRegistry.registerBlock("armorers_crafting_table", () -> new ArmorersCraftingTableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50625_).m_284180_(MapColor.f_283818_).m_60918_(SoundType.f_244244_).m_60955_()));
    public static final RegistryObject<Block> ARMORERS_TINKERING_TABLE = BlockRegistry.registerBlock("armorers_tinkering_table", () -> new ArmorersTinkeringTableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50625_).m_284180_(MapColor.f_283818_).m_60918_(SoundType.f_244244_).m_60955_()));
    public static final RegistryObject<Block> ARMORERS_ANVIL = BlockRegistry.registerBlock("armorers_anvil", () -> new ArmorersAnvilBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_284180_(MapColor.f_283779_).m_60955_()));
    public static final RegistryObject<Block> BLOOMERY_BOTTOM = BlockRegistry.registerBlock("bloomery_bottom", () -> new BloomeryBottomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_284180_(MapColor.f_283913_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BloomeryBottomBlock.LIT) == false ? 0 : 3 + 3 * (Integer)state.m_61143_((Property)BloomeryBottomBlock.LOGS))));
    public static final RegistryObject<Block> BLOOMERY_TOP = BlockRegistry.registerBlock("bloomery_top", () -> new BloomeryTopBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220844_).m_284180_(MapColor.f_283748_).m_60955_()));
    public static final RegistryObject<Block> NETHER_BLOOMERY_BOTTOM = BlockRegistry.registerBlock("nether_bloomery_bottom", () -> new NetherBloomeryBottomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50197_).m_284180_(MapColor.f_283913_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BloomeryBottomBlock.LIT) == false ? 0 : 3 + 3 * (Integer)state.m_61143_((Property)BloomeryBottomBlock.LOGS))));
    public static final RegistryObject<Block> NETHER_BLOOMERY_TOP = BlockRegistry.registerBlock("nether_bloomery_top", () -> new NetherBloomeryTopBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50735_).m_284180_(MapColor.f_283748_).m_60955_()));
    public static final RegistryObject<Block> TEMPERING_BARREL = BlockRegistry.registerBlock("tempering_barrel", () -> new TemperingBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_284180_(MapColor.f_283748_).m_60955_()));
    public static final RegistryObject<Block> HOT_RAW_COPPER_BLOCK = BLOCKS.register("hot_raw_copper_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152599_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_RAW_IRON_BLOCK = BLOCKS.register("hot_raw_iron_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_RAW_GOLD_BLOCK = BLOCKS.register("hot_raw_gold_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152600_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_COPPER_BLOCK = BLOCKS.register("hot_copper_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152504_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_IRON_BLOCK = BLOCKS.register("hot_iron_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_GOLD_BLOCK = BLOCKS.register("hot_gold_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50074_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_DIAMOND_BLOCK = BLOCKS.register("hot_diamond_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_NETHERITE_BLOCK = BLOCKS.register("hot_netherite_block", () -> new HotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_IRON_BARS = BLOCKS.register("hot_iron_bars", () -> new HotIronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> HOT_CHAIN = BLOCKS.register("hot_chain", () -> new HotChainBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50184_).m_284180_(MapColor.f_283832_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, Supplier<T> block) {
        return ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

