/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;

public class UtilityCodecs {
    public static final Codec<Ingredient> INGREDIENT_CODEC = new PrimitiveCodec<Ingredient>(){

        public <T> DataResult<Ingredient> read(DynamicOps<T> ops, T input) {
            try {
                return DataResult.success((Object)CraftingHelper.getIngredient((JsonElement)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject(), (boolean)false));
            }
            catch (JsonSyntaxException error) {
                return DataResult.error(error::getMessage);
            }
        }

        public <T> T write(DynamicOps<T> ops, Ingredient value) {
            return (T)JsonOps.INSTANCE.convertTo(ops, value.m_43942_());
        }
    };
    public static final Codec<ItemStack> STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(ItemStack::m_41720_), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.m_41783_()))).apply((Applicative)instance, UtilityCodecs::createStack));

    public static ItemStack createStack(Item item, int amount, Optional<CompoundTag> tag) {
        CompoundTag nbt = tag.orElse(null);
        return new ItemStack((ItemLike)item, amount, nbt);
    }
}

