/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies;

import com.mojang.datafixers.util.Pair;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.dimension.StarrySkyChunkGenerator;
import de.dafuqs.starryskies.worldgen.dimension.SystemGenerator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class Support {
    private static final List<Point> AROUND_POINTS = new ArrayList<Point>(){
        {
            this.add(new Point(0, 0));
            this.add(new Point(1, -1));
            this.add(new Point(1, 0));
            this.add(new Point(1, 1));
            this.add(new Point(0, -1));
            this.add(new Point(0, 1));
            this.add(new Point(-1, -1));
            this.add(new Point(-1, 0));
            this.add(new Point(-1, 1));
        }
    };

    public static Optional<SphereDistance> getClosestSphere(class_3218 world, class_2338 pos) {
        class_2794 class_27942 = world.method_14178().method_12129();
        if (!(class_27942 instanceof StarrySkyChunkGenerator)) {
            return Optional.empty();
        }
        StarrySkyChunkGenerator starrySkyChunkGenerator = (StarrySkyChunkGenerator)class_27942;
        SystemGenerator systemGenerator = starrySkyChunkGenerator.getSystemGenerator();
        if (systemGenerator != null) {
            PlacedSphere<?> closestSphere = null;
            double currentMinDistance = Double.MAX_VALUE;
            for (PlacedSphere<?> p : systemGenerator.getSystem((class_5281)world, pos)) {
                double currDist = pos.method_10262((class_2382)p.getPosition());
                if (!(currDist < currentMinDistance)) continue;
                currentMinDistance = currDist;
                closestSphere = p;
            }
            return Optional.of(new SphereDistance(closestSphere, currentMinDistance));
        }
        return Optional.empty();
    }

    public static Optional<Pair<class_2338, class_6880<ConfiguredSphere<?, ?>>>> getClosestSphere3x3(@NotNull class_3218 serverWorld, class_2338 position, Predicate<class_6880<ConfiguredSphere<?, ?>>> predicate, class_5455 registryManager) {
        class_2794 class_27942 = serverWorld.method_14178().method_12129();
        if (!(class_27942 instanceof StarrySkyChunkGenerator)) {
            return Optional.empty();
        }
        StarrySkyChunkGenerator starrySkyChunkGenerator = (StarrySkyChunkGenerator)class_27942;
        SystemGenerator systemGenerator = starrySkyChunkGenerator.getSystemGenerator();
        PlacedSphere<?> closestSphere = null;
        double currentMinDistance = Double.MAX_VALUE;
        for (Point currentPoint : AROUND_POINTS) {
            Point systemPos = Support.getSystemCoordinateFromChunkCoordinate(position.method_10263() / 16, position.method_10260() / 16);
            for (PlacedSphere<?> p : systemGenerator.getSystem((class_5281)serverWorld, new Point(systemPos.x + currentPoint.x, systemPos.y + currentPoint.y))) {
                double currDist;
                if (!predicate.test(p.getRegistryEntry(registryManager)) || !((currDist = position.method_10262((class_2382)p.getPosition())) < currentMinDistance)) continue;
                currentMinDistance = currDist;
                closestSphere = p;
            }
            if (closestSphere == null) continue;
            return Optional.of(new Pair((Object)closestSphere.getPosition(), closestSphere.getRegistryEntry(registryManager)));
        }
        return Optional.empty();
    }

    public static <E> E getWeightedRandom(@NotNull Map<E, Float> weights, class_5819 random) {
        E result = null;
        double bestValue = Double.MAX_VALUE;
        for (E element : weights.keySet()) {
            double value = -Math.log(random.method_43058()) / (double)weights.get(element).floatValue();
            if (!(value < bestValue)) continue;
            bestValue = value;
            result = element;
        }
        return result;
    }

    @NotNull
    public static Point getSystemCoordinateFromChunkCoordinate(int chunkX, int chunkZ) {
        int systemSizeChunks = StarrySkies.CONFIG.systemSizeChunks;
        int sysX = chunkX >= 0 ? chunkX / systemSizeChunks : (int)Math.floor((float)chunkX / (float)systemSizeChunks);
        int sysZ = chunkZ >= 0 ? chunkZ / systemSizeChunks : (int)Math.floor((float)chunkZ / (float)systemSizeChunks);
        return new Point(sysX, sysZ);
    }

    public static int getRandomBetween(@NotNull class_5819 random, int lowest, int highest) {
        return lowest + random.method_43048(highest - lowest + 1);
    }

    public static float getRandomBetween(@NotNull class_5819 random, float lowest, float highest) {
        return lowest + random.method_43057() * (highest - lowest);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static double getDistance(@NotNull class_2338 blockPos1, @NotNull class_2338 blockpos2) {
        return Support.getDistance(blockPos1.method_10263(), blockPos1.method_10264(), blockPos1.method_10260(), blockpos2.method_10263(), blockpos2.method_10264(), blockpos2.method_10260());
    }

    public static boolean isBlockPosInChunkPos(@NotNull class_1923 chunkPos, @NotNull class_2338 blockPos) {
        return blockPos.method_10263() >= chunkPos.method_8326() && blockPos.method_10263() < chunkPos.method_8326() + 16 && blockPos.method_10260() >= chunkPos.method_8328() && blockPos.method_10260() < chunkPos.method_8328() + 16;
    }

    public static int getLowerGroundBlock(class_1936 world, @NotNull class_2338 position, int minHeight) {
        class_2338.class_2339 blockPos$Mutable = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        while (blockPos$Mutable.method_10264() > minHeight && world.method_22347((class_2338)blockPos$Mutable)) {
            blockPos$Mutable.method_10098(class_2350.field_11033);
        }
        return blockPos$Mutable.method_10264();
    }

    public static int getUpperGroundBlock(class_1936 world, @NotNull class_2338 position, int minHeight) {
        class_2338.class_2339 blockPos$Mutable = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        while (blockPos$Mutable.method_10264() > minHeight) {
            if (!world.method_22347((class_2338)blockPos$Mutable)) {
                return blockPos$Mutable.method_10264();
            }
            blockPos$Mutable.method_10098(class_2350.field_11036);
        }
        return -1;
    }

    public static class SphereDistance {
        public PlacedSphere<?> sphere;
        public double squaredDistance;

        public SphereDistance(PlacedSphere<?> sphere, double squaredDistance) {
            this.sphere = sphere;
            this.squaredDistance = squaredDistance;
        }
    }
}

