/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecoratorConfig;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SphereDecorator<FC extends SphereDecoratorConfig> {
    private final MapCodec<ConfiguredSphereDecorator<FC, SphereDecorator<FC>>> codec;

    public SphereDecorator(Codec<FC> configCodec) {
        this.codec = configCodec.fieldOf("config").xmap(config -> new ConfiguredSphereDecorator<SphereDecoratorConfig, SphereDecorator>(this, (SphereDecoratorConfig)config), ConfiguredSphereDecorator::config);
    }

    public MapCodec<ConfiguredSphereDecorator<FC, SphereDecorator<FC>>> getCodec() {
        return this.codec;
    }

    public abstract boolean generate(SphereFeatureContext<FC> var1);

    public boolean generateIfValid(FC config, class_5281 world, class_5819 random, class_2338 pos, PlacedSphere<?> sphere) {
        return world.method_37368(pos) && this.generate(new SphereFeatureContext<FC>(world, random, new class_1923(pos), sphere, config));
    }

    protected void placeLootChest(@NotNull class_5281 world, class_2338 blockPos, class_5321<class_52> lootTable, class_5819 random) {
        class_2680 chestBlockState = class_2246.field_10034.method_9564();
        if (world.method_8320(blockPos) == class_2246.field_10382.method_9564()) {
            chestBlockState = (class_2680)chestBlockState.method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(true));
        }
        int r = random.method_43048(4);
        world.method_8652(blockPos, (class_2680)chestBlockState.method_11657((class_2769)class_2281.field_10768, (Comparable)(switch (r) {
            case 0 -> class_2350.field_11043;
            case 1 -> class_2350.field_11035;
            case 2 -> class_2350.field_11034;
            default -> class_2350.field_11039;
        })), 3);
        class_2586 chestBlockEntity = world.method_8321(blockPos);
        if (chestBlockEntity instanceof class_2595) {
            ((class_2595)chestBlockEntity).method_54867(lootTable, random.method_43055());
        }
    }

    @Nullable
    protected class_2338 findNextNonAirBlockInDirection(class_5281 world, class_2338 blockPos, class_2350 direction, int maxBlocks) {
        for (int i = 0; i < maxBlocks; ++i) {
            if (world.method_8320(blockPos.method_10079(direction, i)).method_26215()) continue;
            return blockPos.method_10079(direction, i);
        }
        return null;
    }

    protected List<class_2338> getTopBlocks(class_5281 world, class_1923 chunkPos, PlacedSphere<?> sphere) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int x = sphere.getPosition().method_10263();
        int y = sphere.getPosition().method_10264();
        int z = sphere.getPosition().method_10260();
        int rad = sphere.getRadius();
        int minX = Math.max(chunkPos.method_8326(), x - rad);
        int minZ = Math.max(chunkPos.method_8328(), z - rad);
        int maxX = Math.min(chunkPos.method_8327(), x + rad);
        int maxZ = Math.min(chunkPos.method_8329(), z + rad);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            block1: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = y + rad; y2 > y; --y2) {
                    mutable.method_10103(x2, y2, z2);
                    if (world.method_8320((class_2338)mutable).method_26215()) continue;
                    list.add(mutable.method_10062());
                    continue block1;
                }
            }
        }
        return list;
    }

    protected List<class_2338> getBottomBlocks(class_5281 world, class_1923 chunkPos, PlacedSphere<?> sphere) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int x = sphere.getPosition().method_10263();
        int y = sphere.getPosition().method_10264();
        int z = sphere.getPosition().method_10260();
        int rad = sphere.getRadius();
        int minX = Math.max(chunkPos.method_8326(), x - rad);
        int minZ = Math.max(chunkPos.method_8328(), z - rad);
        int maxX = Math.min(chunkPos.method_8327(), x + rad);
        int maxZ = Math.min(chunkPos.method_8329(), z + rad);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            block1: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int y2 = y - rad; y2 < y; ++y2) {
                    mutable.method_10103(x2, y2, z2);
                    if (world.method_8320((class_2338)mutable).method_26215()) continue;
                    list.add(mutable.method_10062());
                    continue block1;
                }
            }
        }
        return list;
    }

    protected List<class_2338> getTopBlocks(class_5281 world, class_1923 chunkPos, PlacedSphere<?> sphere, class_5819 random, int amount) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int x = sphere.getPosition().method_10263();
        int y = sphere.getPosition().method_10264();
        int z = sphere.getPosition().method_10260();
        int rad = sphere.getRadius();
        int minX = Math.max(chunkPos.method_8326(), x - rad);
        int minZ = Math.max(chunkPos.method_8328(), z - rad);
        int maxX = Math.min(chunkPos.method_8327(), x + rad);
        int maxZ = Math.min(chunkPos.method_8329(), z + rad);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (int i = 0; i < amount; ++i) {
            int x2 = minX + random.method_43048(maxX - minX + 1);
            int z2 = minZ + random.method_43048(maxZ - minZ + 1);
            for (int y2 = y + rad; y2 > y; --y2) {
                mutable.method_10103(x2, y2, z2);
                if (world.method_8320((class_2338)mutable).method_26215()) continue;
                list.add(mutable.method_10062());
                continue block0;
            }
        }
        return list;
    }

    protected List<class_2338> getCaveBottomBlocks(class_5281 world, class_1923 chunkPos, PlacedSphere<?> sphere) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int x = sphere.getPosition().method_10263();
        int y = sphere.getPosition().method_10264();
        int z = sphere.getPosition().method_10260();
        int rad = sphere.getRadius();
        int minX = Math.max(chunkPos.method_8326(), x - rad);
        int minZ = Math.max(chunkPos.method_8328(), z - rad);
        int maxX = Math.min(chunkPos.method_8327(), x + rad);
        int maxZ = Math.min(chunkPos.method_8329(), z + rad);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            block1: for (int z2 = minZ; z2 <= maxZ; ++z2) {
                boolean hitShell = false;
                for (int y2 = y - rad; y2 < y; ++y2) {
                    boolean airOrFluid;
                    mutable.method_10103(x2, y2, z2);
                    class_2680 state = world.method_8320((class_2338)mutable);
                    boolean bl = airOrFluid = state.method_26215() || state.method_26227().method_15772() != class_3612.field_15906;
                    if (airOrFluid && !hitShell) continue;
                    if (!airOrFluid) {
                        hitShell = true;
                        continue;
                    }
                    list.add(mutable.method_10074().method_10062());
                    continue block1;
                }
            }
        }
        return list;
    }

    protected List<class_2338> getRandomCaveBottomBlocks(class_5281 world, class_1923 chunkPos, PlacedSphere<?> sphere, class_5819 random, int amount) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int x = sphere.getPosition().method_10263();
        int y = sphere.getPosition().method_10264();
        int z = sphere.getPosition().method_10260();
        int rad = sphere.getRadius();
        int minX = Math.max(chunkPos.method_8326(), x - rad);
        int minZ = Math.max(chunkPos.method_8328(), z - rad);
        int maxX = Math.min(chunkPos.method_8327(), x + rad);
        int maxZ = Math.min(chunkPos.method_8329(), z + rad);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (int i = 0; i < amount; ++i) {
            int x2 = minX + random.method_43048(maxX - minX + 1);
            int z2 = minZ + random.method_43048(maxZ - minZ + 1);
            boolean hitShell = false;
            for (int y2 = y - rad; y2 < y; ++y2) {
                boolean airOrFluid;
                mutable.method_10103(x2, y2, z2);
                class_2680 state = world.method_8320((class_2338)mutable);
                boolean bl = airOrFluid = state.method_26215() || state.method_26227().method_15772() != class_3612.field_15906;
                if (airOrFluid && !hitShell) continue;
                if (!airOrFluid) {
                    hitShell = true;
                    continue;
                }
                list.add(mutable.method_10074().method_10062());
                continue block0;
            }
        }
        return list;
    }
}

