/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import de.dafuqs.starryskies.worldgen.spheres.TreasureChestEntry;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CaveSphere
extends Sphere<Config> {
    public CaveSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        class_5321<class_52> lootTable = null;
        if (config.treasureEntry.isPresent() && (float)random.method_43055() < config.treasureEntry.get().chance().floatValue()) {
            lootTable = config.treasureEntry.get().lootTable();
        }
        class_4651 shellProvider = config.shellBlock.getForSphere((class_5819)random, pos);
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, shellProvider, config.topBlock.isPresent() ? config.topBlock.get().getForSphere((class_5819)random, pos) : shellProvider, config.bottomBlock.isPresent() ? config.bottomBlock.get().getForSphere((class_5819)random, pos) : shellProvider, config.caveFloorBlock.isPresent() ? config.caveFloorBlock.get().getForSphere((class_5819)random, pos) : shellProvider, config.shellThickness.method_33920((class_5819)random), lootTable);
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("shell_block").forGetter(config -> config.shellBlock), (App)SphereStateProvider.CODEC.optionalFieldOf("top_block").forGetter(config -> config.topBlock), (App)SphereStateProvider.CODEC.optionalFieldOf("bottom_block").forGetter(config -> config.bottomBlock), (App)SphereStateProvider.CODEC.optionalFieldOf("cave_floor_block").forGetter(config -> config.bottomBlock), (App)class_5863.method_33916((float)1.0f, (float)32.0f).fieldOf("shell_thickness").forGetter(config -> config.shellThickness), (App)TreasureChestEntry.CODEC.optionalFieldOf("treasure_chest").forGetter(config -> config.treasureEntry)).apply((Applicative)instance, (sphereConfig, shellBlock, topBlock, bottomBlock, caveFloorBlock, shellRadius, treasureEntry) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)shellBlock, (Optional<SphereStateProvider>)topBlock, (Optional<SphereStateProvider>)bottomBlock, (Optional<SphereStateProvider>)caveFloorBlock, (class_5863)shellRadius, (Optional<TreasureChestEntry>)treasureEntry)));
        private final SphereStateProvider shellBlock;
        private final Optional<SphereStateProvider> topBlock;
        private final Optional<SphereStateProvider> bottomBlock;
        private final Optional<SphereStateProvider> caveFloorBlock;
        private final class_5863 shellThickness;
        private final Optional<TreasureChestEntry> treasureEntry;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider shellBlock, Optional<SphereStateProvider> topBlock, Optional<SphereStateProvider> bottomBlock, Optional<SphereStateProvider> caveFloorBlock, class_5863 shellThickness, Optional<TreasureChestEntry> treasureEntry) {
            super(size, decorators, spawns, generation);
            this.shellBlock = shellBlock;
            this.topBlock = topBlock;
            this.bottomBlock = bottomBlock;
            this.caveFloorBlock = caveFloorBlock;
            this.shellThickness = shellThickness;
            this.treasureEntry = treasureEntry;
        }
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private static final class_2680 AIR = class_2246.field_10543.method_9564();
        private final class_4651 shellBlock;
        private final class_4651 topBlock;
        private final class_4651 bottomBlock;
        private final class_4651 caveFloorBlock;
        private final float shellThickness;
        @Nullable
        private final class_5321<class_52> chestLootTable;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 shellBlock, class_4651 topBlock, class_4651 bottomBlock, class_4651 caveFloorBlock, float shellRadius, @Nullable class_5321<class_52> chestLootTable) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.shellBlock = shellBlock;
            this.topBlock = topBlock;
            this.bottomBlock = bottomBlock;
            this.caveFloorBlock = caveFloorBlock;
            this.shellThickness = shellRadius;
            this.chestLootTable = chestLootTable;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            boolean hasChest = this.chestLootTable != null;
            Object2ObjectArrayMap floorBlocks = new Object2ObjectArrayMap();
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if ((float)d > this.radius - 1.0f) {
                            if (this.isBottomBlock(d, x2, y2, z2)) {
                                chunk.method_66480((class_2338)currBlockPos, this.bottomBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                                continue;
                            }
                            if (this.isTopBlock(d, x2, y2, z2)) {
                                chunk.method_66480((class_2338)currBlockPos, this.topBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                                continue;
                            }
                            chunk.method_66480((class_2338)currBlockPos, this.shellBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        if ((float)d <= this.radius - this.shellThickness) {
                            Point point = new Point(x2, z2);
                            if (floorBlocks.containsKey(point)) continue;
                            floorBlocks.put(new Point(x2, z2), y2);
                            chunk.method_66480(currBlockPos.method_10074(), this.caveFloorBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            if (!hasChest || x2 - x != 0 || z2 - z != 0) continue;
                            this.placeCenterChestWithLootTable(chunk, currBlockPos.method_10062(), this.chestLootTable, (class_5819)this.random, false);
                            continue;
                        }
                        if (!((float)d < this.radius)) continue;
                        chunk.method_66480((class_2338)currBlockPos, this.shellBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ CaveSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nShellBlock: " + String.valueOf(this.shellBlock) + "\nShellThickness: " + this.shellThickness + "\nCaveFloorBlock: " + String.valueOf(this.caveFloorBlock) + "\nTopBlock: " + String.valueOf(this.topBlock) + "\nBottomBlock: " + String.valueOf(this.bottomBlock);
        }
    }
}

