/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class MushroomSphere
extends Sphere<Config> {
    public MushroomSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.stemBlock, config.mushroomBlock, config.shellThickness.method_35008((class_5819)random));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final class_2680 stemBlock;
        private final class_2680 mushroomBlock;
        private final float shellRadius;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_2680 stemBlock, class_2680 mushroomBlock, float shellRadius) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.stemBlock = stemBlock;
            this.mushroomBlock = mushroomBlock;
            this.shellRadius = shellRadius;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            class_2680 placementBlockstateInner = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.mushroomBlock.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(false));
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        long rounded = Math.round(d);
                        if ((float)rounded <= this.radius - this.shellRadius) {
                            chunk.method_66480((class_2338)currBlockPos, this.stemBlock);
                            continue;
                        }
                        if ((double)d <= (double)this.radius - 0.5) {
                            chunk.method_66480((class_2338)currBlockPos, placementBlockstateInner);
                            continue;
                        }
                        class_2680 placementBlockstateOuter = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.mushroomBlock.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true));
                        chunk.method_66480((class_2338)currBlockPos, placementBlockstateOuter);
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ MushroomSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nMushroom: " + this.mushroomBlock.toString() + " (Radius: " + this.shellRadius + ")\nStem: " + this.stemBlock.toString();
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)class_2680.field_24734.fieldOf("stem_block").forGetter(config -> config.stemBlock), (App)class_2680.field_24734.fieldOf("mushroom_block").forGetter(config -> config.mushroomBlock), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness)).apply((Applicative)instance, (sphereConfig, stemBlock, mushroomBlock, shellThickness) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (class_2680)stemBlock, (class_2680)mushroomBlock, (class_6017)shellThickness)));
        protected final class_2680 stemBlock;
        protected final class_2680 mushroomBlock;
        protected final class_6017 shellThickness;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, class_2680 stemBlock, class_2680 mushroomBlock, class_6017 shellThickness) {
            super(size, decorators, spawns, generation);
            this.stemBlock = stemBlock;
            this.mushroomBlock = mushroomBlock;
            this.shellThickness = shellThickness;
        }
    }
}

