/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.client.sky;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.dafuqs.starryskies.StarrySkies;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9851;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class StarrySkyBox
implements DimensionRenderingRegistry.SkyRenderer {
    private GpuBuffer skyVertexBuffer;
    public final class_2960 UP;
    public final class_2960 DOWN;
    public final class_2960 WEST;
    public final class_2960 EAST;
    public final class_2960 NORTH;
    public final class_2960 SOUTH;

    public StarrySkyBox(String up, String down, String west, String east, String north, String south) {
        this.UP = StarrySkies.id(up);
        this.DOWN = StarrySkies.id(down);
        this.WEST = StarrySkies.id(west);
        this.EAST = StarrySkies.id(east);
        this.NORTH = StarrySkies.id(north);
        this.SOUTH = StarrySkies.id(south);
    }

    public void render(WorldRenderContext context) {
        class_5636 cameraSubmersionType = context.camera().method_19334();
        if (cameraSubmersionType == class_5636.field_27887 || cameraSubmersionType == class_5636.field_27885 || this.hasBlindnessOrDarkness(context.camera())) {
            return;
        }
        if (this.skyVertexBuffer == null) {
            this.skyVertexBuffer = StarrySkyBox.createStarrySky();
        }
        this.renderStarrySky();
    }

    private boolean hasBlindnessOrDarkness(class_4184 camera) {
        class_1297 var3 = camera.method_19331();
        if (!(var3 instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)var3;
        return livingEntity.method_6059(class_1294.field_5919) || livingEntity.method_6059(class_1294.field_38092);
    }

    private static GpuBuffer createStarrySky() {
        class_9799 bufferAllocator = new class_9799(24 * class_290.field_1575.getVertexSize());
        class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1575);
        for (int i = 0; i < 6; ++i) {
            Matrix4f matrix4f = new Matrix4f();
            switch (i) {
                case 1: {
                    matrix4f.rotationX(1.5707964f);
                    break;
                }
                case 2: {
                    matrix4f.rotationX(-1.5707964f);
                    break;
                }
                case 3: {
                    matrix4f.rotationX((float)Math.PI);
                    break;
                }
                case 4: {
                    matrix4f.rotationZ(1.5707964f);
                    break;
                }
                case 5: {
                    matrix4f.rotationZ(-1.5707964f);
                }
            }
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_39415(-14145496);
        }
        class_9801 builtBuffer = bufferBuilder.method_60800();
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "StarrySkies sky vertex buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, builtBuffer.method_60818());
        builtBuffer.close();
        bufferAllocator.close();
        return gpuBuffer;
    }

    private void renderStarrySky() {
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_1044 abstractTexture = textureManager.method_4619(this.DOWN);
        abstractTexture.method_65923(class_9851.field_52395, false);
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer gpuBuffer = shapeIndexBuffer.method_68274(36);
        GpuTexture gpuTexture = class_310.method_1551().method_1522().method_30277();
        GpuTexture gpuTexture2 = class_310.method_1551().method_1522().method_30278();
        RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(gpuTexture, OptionalInt.empty(), gpuTexture2, OptionalDouble.empty());
        renderPass.setPipeline(class_10799.field_56875);
        renderPass.bindSampler("Sampler0", abstractTexture.method_68004());
        renderPass.setVertexBuffer(0, this.skyVertexBuffer);
        renderPass.setIndexBuffer(gpuBuffer, shapeIndexBuffer.method_31924());
        renderPass.drawIndexed(0, 36);
        renderPass.close();
    }
}

