/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6880;

public class SphereConfig {
    public static final MapCodec<SphereConfig> CONFIG_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5863.method_33916((float)1.0f, (float)64.0f).fieldOf("size").forGetter(sphereConfig -> sphereConfig.size), (App)Codec.unboundedMap(ConfiguredSphereDecorator.REGISTRY_CODEC, (Codec)Codec.FLOAT).fieldOf("decorators").forGetter(sphereConfig -> sphereConfig.decorators), (App)SphereEntitySpawnDefinition.CODEC.listOf().fieldOf("spawns").forGetter(sphereConfig -> sphereConfig.spawns), (App)Generation.CODEC.optionalFieldOf("generation").forGetter(sphereConfig -> sphereConfig.generation)).apply((Applicative)instance, SphereConfig::new));
    public final class_5863 size;
    public final Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators;
    public final List<SphereEntitySpawnDefinition> spawns;
    public final Optional<Generation> generation;

    public SphereConfig(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<Generation> generation) {
        this.size = size;
        this.decorators = decorators;
        this.spawns = spawns;
        this.generation = generation;
    }

    List<class_6880<ConfiguredSphereDecorator<?, ?>>> selectDecorators(class_5819 random) {
        ArrayList result = new ArrayList();
        for (Map.Entry<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> entry : this.decorators.entrySet()) {
            if (!(random.method_43057() < entry.getValue().floatValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    List<class_3545<class_1299<?>, Integer>> selectSpawns(class_5819 random) {
        ArrayList result = new ArrayList();
        for (SphereEntitySpawnDefinition entry : this.spawns) {
            if (!(random.method_43057() < entry.chance)) continue;
            int count = Support.getRandomBetween(random, entry.minCount, entry.maxCount);
            result.add(new class_3545(entry.entityType, (Object)count));
        }
        return result;
    }

    public record Generation(class_2960 group, float weight) {
        public static final Codec<Generation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("group").forGetter(Generation::group), (App)Codec.FLOAT.fieldOf("weight").forGetter(Generation::weight)).apply((Applicative)instance, Generation::new));
    }
}

