/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import de.dafuqs.starryskies.worldgen.decorators.RuinedPortalDecoratorConfig;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class RuinedPortalDecorator
extends SphereDecorator<RuinedPortalDecoratorConfig> {
    private static final class_2680 NETHERRACK = class_2246.field_10515.method_9564();
    private static final class_2680 MAGMA_BLOCK = class_2246.field_10092.method_9564();
    private static final class_2680 LAVA = class_2246.field_10164.method_9564();
    private static final class_2680 OBSIDIAN = class_2246.field_10540.method_9564();
    private static final float OBSIDIAN_CHANCE = 0.9f;

    public RuinedPortalDecorator(Codec<RuinedPortalDecoratorConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(SphereFeatureContext<RuinedPortalDecoratorConfig> context) {
        class_5281 world = context.getWorld();
        PlacedSphere<?> sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        RuinedPortalDecoratorConfig config = context.getConfig();
        if (!sphere.isCenterInChunk(origin)) {
            return false;
        }
        class_2338 spherePosition = sphere.getPosition();
        for (int x = -sphere.getRadius(); x <= sphere.getRadius(); ++x) {
            block5: for (int z = -sphere.getRadius(); z <= sphere.getRadius(); ++z) {
                int startY = spherePosition.method_10264() + sphere.getRadius() + 1;
                int upperY = Support.getLowerGroundBlock((class_1936)world, new class_2338(spherePosition.method_10263() + x, startY, spherePosition.method_10260() + z), spherePosition.method_10264());
                if (upperY <= spherePosition.method_10264()) continue;
                int randomI = random.method_43048(sphere.getRadius() + 1);
                if (!((double)Math.abs(x * z) * 1.5 < (double)(randomI * randomI))) continue;
                class_2338 currentBlockPos = new class_2338(spherePosition.method_10263() + x, upperY, spherePosition.method_10260() + z);
                switch (random.method_43048(6)) {
                    case 0: {
                        world.method_8652(currentBlockPos, MAGMA_BLOCK, 3);
                        continue block5;
                    }
                    case 1: {
                        world.method_8652(currentBlockPos, LAVA, 3);
                        world.method_22350(currentBlockPos).method_12039(currentBlockPos);
                        continue block5;
                    }
                    default: {
                        world.method_8652(currentBlockPos, NETHERRACK, 3);
                    }
                }
            }
        }
        int centerTopBlockY = Support.getLowerGroundBlock((class_1936)world, new class_2338(spherePosition.method_10263(), spherePosition.method_10264() + sphere.getRadius() + 1, spherePosition.method_10260()), spherePosition.method_10264());
        class_2338 currentBlockPos = new class_2338(spherePosition.method_10263(), centerTopBlockY, spherePosition.method_10260());
        this.placePortalBlock(world, currentBlockPos, random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10084(), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10084(), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(1), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(2), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(3), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(3), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(4), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(4), random);
        this.placePortalBlock(world, currentBlockPos.method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 1).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 1).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11035, 2).method_10086(5), random);
        this.placePortalBlock(world, currentBlockPos.method_10079(class_2350.field_11043, 2).method_10086(5), random);
        int randomX = Support.getRandomBetween(random, spherePosition.method_10263() - sphere.getRadius() / 2, spherePosition.method_10263() + sphere.getRadius() / 2);
        int randomZ = Support.getRandomBetween(random, spherePosition.method_10260() - sphere.getRadius() / 2, spherePosition.method_10260() + sphere.getRadius() / 2);
        centerTopBlockY = Support.getLowerGroundBlock((class_1936)world, new class_2338(randomX, spherePosition.method_10264() + sphere.getRadius() + 2, randomZ), spherePosition.method_10264());
        if (centerTopBlockY != spherePosition.method_10264()) {
            class_2338 lootChestPosition = new class_2338(randomX, centerTopBlockY, randomZ).method_10084();
            this.placeLootChest(world, lootChestPosition, config.lootTable(), random);
        }
        return true;
    }

    private void placePortalBlock(class_5281 world, class_2338 blockPos, class_5819 random) {
        if (random.method_43057() < 0.9f) {
            world.method_8652(blockPos, OBSIDIAN, 3);
        }
    }
}

