/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.registries.StarryRegistryKeys;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.dimension.SystemGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1948;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5381;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import org.jetbrains.annotations.NotNull;

public class StarrySkyChunkGenerator
extends class_2794 {
    public static final MapCodec<StarrySkyChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.field_12761), (App)class_5381.method_29749(StarryRegistryKeys.SYSTEM_GENERATOR, SystemGenerator.CODEC).fieldOf("system_generator").forGetter(generator -> generator.systemGenerator)).apply((Applicative)instance, StarrySkyChunkGenerator::new));
    protected final class_6880<SystemGenerator> systemGenerator;

    public StarrySkyChunkGenerator(class_1966 biomeSource, class_6880<SystemGenerator> systemGenerator) {
        super(biomeSource);
        this.systemGenerator = systemGenerator;
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int chunkPosStartX = chunkPos.method_8326();
        int chunkPosStartZ = chunkPos.method_8328();
        if (((SystemGenerator)this.systemGenerator.comp_349()).getFloorHeight() > 0) {
            for (int y = 0; y < this.method_16398(); ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        chunk.method_66480(new class_2338(chunkPosStartX + x, y, chunkPosStartZ + z), ((SystemGenerator)this.systemGenerator.comp_349()).getSeaBlock(y));
                    }
                }
            }
        }
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk) {
        for (PlacedSphere<?> sphere : ((SystemGenerator)this.systemGenerator.comp_349()).getSystem(chunk, seed, structureAccessor.method_41036())) {
            if (!sphere.isInChunk(chunk.method_12004())) continue;
            StarrySkies.LOGGER.debug("Generating sphere in chunk x:{} z:{} (StartX:{} StartZ:{}) {}", new Object[]{chunk.method_12004().field_9181, chunk.method_12004().field_9180, chunk.method_12004().method_8326(), chunk.method_12004().method_8328(), sphere.getDescription(structureAccessor.method_41036())});
            sphere.generate(chunk, structureAccessor.method_41036());
            StarrySkies.LOGGER.debug("Generation Finished.");
        }
    }

    public int method_12104() {
        return ((SystemGenerator)this.systemGenerator.comp_349()).getFloorHeight();
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_12107(@NotNull class_3233 chunkRegion) {
        class_1923 chunkPos = chunkRegion.method_33561();
        class_6880 biome = chunkRegion.method_23753(chunkPos.method_8323().method_33096(chunkRegion.method_31600()));
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
        chunkRandom.method_12661(chunkRegion.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
        class_1948.method_8661((class_5425)chunkRegion, (class_6880)biome, (class_1923)chunkPos, (class_5819)chunkRandom);
        for (PlacedSphere<?> sphere : ((SystemGenerator)this.systemGenerator.comp_349()).getSystem((class_1936)chunkRegion.method_8410(), chunkRegion.method_8412(), chunkPos.field_9181, chunkPos.field_9180)) {
            sphere.populateEntities(chunkPos, chunkRegion, chunkRandom);
        }
    }

    public int method_16398() {
        return ((SystemGenerator)this.systemGenerator.comp_349()).getFloorHeight();
    }

    public int method_33730() {
        return 0;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return ((SystemGenerator)this.systemGenerator.comp_349()).getFloorHeight();
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        Object[] states = new class_2680[world.method_31605()];
        Arrays.fill(states, class_2246.field_10124.method_9564());
        return new class_4966(world.method_31607(), (class_2680[])states);
    }

    public SystemGenerator getSystemGenerator() {
        return (SystemGenerator)this.systemGenerator.comp_349();
    }
}

