/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class FluidCoreSphere
extends Sphere<Config> {
    public FluidCoreSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.shellBlock.getForSphere((class_5819)random, pos), config.shellThickness.method_35008((class_5819)random), config.fluidBlock, config.fillPercent.method_33920((class_5819)random), config.holeInBottomChance > random.method_43057(), config.coreBlock.getForSphere((class_5819)random, pos), config.coreRadius.method_33920((class_5819)random));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
        private final class_4651 shellBlock;
        private final float shellRadius;
        private final class_2680 fluidBlock;
        private final float fillPercent;
        private final boolean holeInBottom;
        private final class_4651 coreBlock;
        private final float coreRadius;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 shellBlock, float shellRadius, class_2680 fluidBlock, float fillPercent, boolean holeInBottom, class_4651 coreBlock, float coreRadius) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.shellBlock = shellBlock;
            this.shellRadius = shellRadius;
            this.fluidBlock = fluidBlock;
            this.fillPercent = fillPercent;
            this.holeInBottom = holeInBottom;
            this.coreBlock = coreBlock;
            this.coreRadius = coreRadius;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            float liquidRadius = this.radius - this.shellRadius;
            float maxLiquidY = (float)y + (this.fillPercent * liquidRadius * 2.0f - liquidRadius);
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if (this.holeInBottom && x - x2 == 0 && z - z2 == 0 && (float)(y - y2 + 1) >= liquidRadius) {
                            chunk.method_66480(new class_2338((class_2382)currBlockPos), this.fluidBlock);
                            chunk.method_12039((class_2338)currBlockPos);
                            continue;
                        }
                        if ((float)d <= this.coreRadius) {
                            chunk.method_66480((class_2338)currBlockPos, this.coreBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        if ((float)d <= liquidRadius) {
                            if ((float)y2 <= maxLiquidY) {
                                chunk.method_66480((class_2338)currBlockPos, this.fluidBlock);
                                continue;
                            }
                            chunk.method_66480((class_2338)currBlockPos, this.CAVE_AIR);
                            continue;
                        }
                        chunk.method_66480((class_2338)currBlockPos, this.shellBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ FluidCoreSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + "(Radius: " + this.shellRadius + ")\nLiquid: " + this.fluidBlock.toString() + "\nCore: " + String.valueOf(this.coreBlock) + "(Radius: " + this.coreRadius + ")\nFill Percent: " + this.fillPercent + "\nHole in bottom: " + this.holeInBottom;
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("shell_block").forGetter(config -> config.shellBlock), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness), (App)class_2680.field_24734.fieldOf("fluid_block").forGetter(config -> config.fluidBlock), (App)class_5863.method_33916((float)0.0f, (float)1.0f).fieldOf("fluid_fill_percent").forGetter(config -> config.fillPercent), (App)class_5699.field_34387.fieldOf("hole_in_bottom_chance").forGetter(config -> Float.valueOf(config.holeInBottomChance)), (App)SphereStateProvider.CODEC.fieldOf("core_block").forGetter(config -> config.coreBlock), (App)class_5863.method_33916((float)1.0f, (float)32.0f).fieldOf("core_radius").forGetter(config -> config.coreRadius)).apply((Applicative)instance, (sphereConfig, shellBlock, shellThickness, fluidBlock, fillAmount, holeInBottom, coreBlock, coreRadius) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)shellBlock, (class_6017)shellThickness, (class_2680)fluidBlock, (class_5863)fillAmount, holeInBottom.floatValue(), (SphereStateProvider)coreBlock, (class_5863)coreRadius)));
        protected final SphereStateProvider shellBlock;
        protected final class_6017 shellThickness;
        protected final class_2680 fluidBlock;
        protected final class_5863 fillPercent;
        protected final float holeInBottomChance;
        private final SphereStateProvider coreBlock;
        private final class_5863 coreRadius;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider shellBlock, class_6017 shellThickness, class_2680 fluidBlock, class_5863 fillPercent, float holeInBottomChance, SphereStateProvider coreBlock, class_5863 coreRadius) {
            super(size, decorators, spawns, generation);
            this.shellBlock = shellBlock;
            this.shellThickness = shellThickness;
            this.fluidBlock = fluidBlock;
            this.fillPercent = fillPercent;
            this.holeInBottomChance = holeInBottomChance;
            this.coreBlock = coreBlock;
            this.coreRadius = coreRadius;
        }
    }
}

