/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6880;

public class ModularSphere
extends Sphere<Config> {
    public ModularSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        class_4651 mainProvider = config.mainBlock.getForSphere((class_5819)random, pos);
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, mainProvider, config.topBlock.isPresent() ? config.topBlock.get().getForSphere((class_5819)random, pos) : mainProvider, config.bottomBlock.isPresent() ? config.bottomBlock.get().getForSphere((class_5819)random, pos) : mainProvider);
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("main_block").forGetter(config -> config.mainBlock), (App)SphereStateProvider.CODEC.optionalFieldOf("top_block").forGetter(config -> config.topBlock), (App)SphereStateProvider.CODEC.optionalFieldOf("bottom_block").forGetter(config -> config.bottomBlock)).apply((Applicative)instance, (sphereConfig, mainBlock, topBlock, bottomBlock) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)mainBlock, (Optional<SphereStateProvider>)topBlock, (Optional<SphereStateProvider>)bottomBlock)));
        protected final SphereStateProvider mainBlock;
        protected final Optional<SphereStateProvider> topBlock;
        protected final Optional<SphereStateProvider> bottomBlock;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider mainBlock, Optional<SphereStateProvider> topBlock, Optional<SphereStateProvider> bottomBlock) {
            super(size, decorators, spawns, generation);
            this.mainBlock = mainBlock;
            this.topBlock = topBlock;
            this.bottomBlock = bottomBlock;
        }
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final class_4651 mainBlock;
        private final class_4651 topBlock;
        private final class_4651 bottomBlock;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 mainBlock, class_4651 topBlock, class_4651 bottomBlock) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.mainBlock = mainBlock;
            this.topBlock = topBlock;
            this.bottomBlock = bottomBlock;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if (this.bottomBlock != null && this.isBottomBlock(d, x2, y2, z2)) {
                            chunk.method_66480((class_2338)currBlockPos, this.bottomBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        if (this.topBlock != null && this.isTopBlock(d, x2, y2, z2)) {
                            chunk.method_66480((class_2338)currBlockPos, this.topBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                            continue;
                        }
                        chunk.method_66480((class_2338)currBlockPos, this.mainBlock.method_23455((class_5819)this.random, (class_2338)currBlockPos));
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ ModularSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nMaterial: " + String.valueOf(this.mainBlock) + "\nTopBlock: " + String.valueOf(this.topBlock) + "\nBottomBlock: " + String.valueOf(this.bottomBlock);
        }
    }
}

