/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen;

import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.registries.StarryRegistryKeys;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public abstract class PlacedSphere<SC extends SphereConfig> {
    protected ConfiguredSphere<? extends Sphere<SC>, SC> configuredSphere;
    protected float radius;
    protected List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators;
    protected List<class_3545<class_1299<?>, Integer>> spawns;
    protected class_2338 position;
    protected class_2919 random;

    public PlacedSphere(ConfiguredSphere<? extends Sphere<SC>, SC> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random) {
        this.configuredSphere = configuredSphere;
        this.radius = radius;
        this.decorators = decorators;
        this.spawns = spawns;
        this.random = random;
    }

    public Optional<class_5321<ConfiguredSphere<?, ?>>> getRegistryKey(class_5455 registryManager) {
        return registryManager.method_30530(StarryRegistryKeys.CONFIGURED_SPHERE).method_29113(this.configuredSphere);
    }

    public class_6880<ConfiguredSphere<?, ?>> getRegistryEntry(class_5455 registryManager) {
        return registryManager.method_30530(StarryRegistryKeys.CONFIGURED_SPHERE).method_47983(this.configuredSphere);
    }

    public class_2960 getID(class_5455 registryManager) {
        class_2378 registry = registryManager.method_30530(StarryRegistryKeys.CONFIGURED_SPHERE);
        return registry.method_10221(this.configuredSphere);
    }

    public abstract void generate(class_2791 var1, class_5455 var2);

    public class_2338 getPosition() {
        return this.position;
    }

    public void setPosition(class_2338 position) {
        this.position = position;
    }

    public int getRadius() {
        return Math.round(this.radius);
    }

    public abstract String getDescription(class_5455 var1);

    public boolean isInChunk(@NotNull class_1923 chunkPos) {
        int radius = this.getRadius();
        int xMin = this.position.method_10263() - radius - 16;
        int xMax = this.position.method_10263() + radius + 15;
        int zMin = this.position.method_10260() - radius - 16;
        int zMax = this.position.method_10260() + radius + 15;
        return chunkPos.method_8326() >= xMin && chunkPos.method_8327() <= xMax && chunkPos.method_8328() >= zMin && chunkPos.method_8329() <= zMax;
    }

    public boolean isCenterInChunk(@NotNull class_1923 chunkPos) {
        return this.getPosition().method_10263() >= chunkPos.method_8326() && this.getPosition().method_10263() <= chunkPos.method_8326() + 15 && this.getPosition().method_10260() >= chunkPos.method_8328() && this.getPosition().method_10260() <= chunkPos.method_8328() + 15;
    }

    public void decorate(class_5281 world, class_2338 origin, class_5819 random) {
        if (!this.decorators.isEmpty()) {
            for (class_6880<ConfiguredSphereDecorator<?, ?>> decorator : this.decorators) {
                StarrySkies.LOGGER.debug("Decorator: {}", (Object)decorator.getClass());
                try {
                    ((ConfiguredSphereDecorator)decorator.comp_349()).generate(world, random, origin, this);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                StarrySkies.LOGGER.debug("Decorator finished");
            }
        }
    }

    protected boolean isTopBlock(long distanceFromSphereCenter, double x, double y, double z) {
        if ((float)distanceFromSphereCenter > this.radius - 1.0f) {
            long dist2 = Math.round(Support.getDistance(this.getPosition().method_10263(), this.getPosition().method_10264(), this.getPosition().method_10260(), x, y + 1.0, z));
            return (float)dist2 > this.radius;
        }
        return false;
    }

    protected boolean isBottomBlock(long distanceFromSphereCenter, double x, double y, double z) {
        if ((float)distanceFromSphereCenter > this.radius - 1.0f) {
            long dist2 = Math.round(Support.getDistance(this.getPosition().method_10263(), this.getPosition().method_10264(), this.getPosition().method_10260(), x, y - 1.0, z));
            return (float)dist2 > this.radius;
        }
        return false;
    }

    protected void placeCenterChestWithLootTable(class_2791 chunk, class_2338 blockPos, class_5321<class_52> lootTable, class_5819 random, boolean waterLogged) {
        class_2680 chestBlockState = waterLogged ? (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(true)) : class_2246.field_10034.method_9564();
        chunk.method_12010(blockPos, chestBlockState, false);
        class_2595 blockEntity = new class_2595(blockPos, chestBlockState);
        chunk.method_12007((class_2586)new class_2595(blockPos, chestBlockState));
        blockEntity.method_54867(lootTable, random.method_43055());
    }

    public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
        if (this.isCenterInChunk(chunkPos)) {
            StarrySkies.LOGGER.debug("Populating entities for sphere in chunk x:{} z:{} (StartX:{} StartZ:{}) {}", new Object[]{chunkPos.field_9181, chunkPos.field_9180, chunkPos.method_8326(), chunkPos.method_8328(), this.getDescription(chunkRegion.method_30349())});
            for (class_3545<class_1299<?>, Integer> spawnEntry : this.spawns) {
                int xCord = chunkPos.method_8326();
                int zCord = chunkPos.method_8328();
                chunkRandom.method_12661(chunkRegion.method_8412(), xCord, zCord);
                for (int i = 0; i < (Integer)spawnEntry.method_15441(); ++i) {
                    class_1297 entity;
                    int minHeight;
                    int startingZ;
                    int startingY;
                    int startingX = this.getPosition().method_10263();
                    class_2338.class_2339 blockPos = new class_2338.class_2339(startingX, startingY = this.getPosition().method_10264() + this.getRadius() + 1, startingZ = this.getPosition().method_10260());
                    int height = Support.getLowerGroundBlock((class_1936)chunkRegion, (class_2338)blockPos, minHeight = this.getPosition().method_10264() - this.getRadius()) + 1;
                    if (height == 0 || (entity = ((class_1299)spawnEntry.method_15442()).method_5883((class_1937)chunkRegion.method_8410(), class_3730.field_16472)) == null) continue;
                    float width = entity.method_17681();
                    double xPos = class_3532.method_15350((double)startingX, (double)((double)xCord + (double)width), (double)((double)xCord + 16.0 - (double)width));
                    double zLength = class_3532.method_15350((double)startingZ, (double)((double)zCord + (double)width), (double)((double)zCord + 16.0 - (double)width));
                    try {
                        class_1308 mobentity;
                        entity.method_5808(xPos, (double)height, zLength, chunkRandom.method_43057() * 360.0f, 0.0f);
                        if (!(entity instanceof class_1308) || !(mobentity = (class_1308)entity).method_5979((class_1936)chunkRegion, class_3730.field_16472) || !mobentity.method_5957((class_4538)chunkRegion)) continue;
                        mobentity.method_5943((class_5425)chunkRegion, chunkRegion.method_8404(mobentity.method_24515()), class_3730.field_16472, null);
                        boolean success = chunkRegion.method_8649((class_1297)mobentity);
                        if (success) continue;
                        return;
                    }
                    catch (Exception exception) {
                        StarrySkies.LOGGER.warn("Failed to spawn mob on sphere{}\nException: {}", (Object)this.getDescription(chunkRegion.method_30349()), (Object)exception);
                    }
                }
            }
            StarrySkies.LOGGER.debug("Finished populating");
        }
    }

    protected void placeSpawner(@NotNull class_1936 worldAccess, class_2338 blockPos, class_1299<?> entityType) {
        worldAccess.method_8652(blockPos, class_2246.field_10260.method_9564(), 3);
        class_2586 blockEntity = worldAccess.method_8321(blockPos);
        if (blockEntity instanceof class_2636) {
            class_2636 mobSpawnerBlockEntity = (class_2636)blockEntity;
            mobSpawnerBlockEntity.method_11390().method_8274(entityType, null, worldAccess.method_8409(), blockPos);
        }
    }
}

