/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import de.dafuqs.starryskies.worldgen.decorators.HugePlantDecoratorConfig;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class HugePlantDecorator
extends SphereDecorator<HugePlantDecoratorConfig> {
    public HugePlantDecorator(Codec<HugePlantDecoratorConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(SphereFeatureContext<HugePlantDecoratorConfig> context) {
        class_5281 world = context.getWorld();
        PlacedSphere<?> sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        HugePlantDecoratorConfig config = context.getConfig();
        for (class_2338 bp : this.getTopBlocks(world, origin, sphere)) {
            class_2680 posState = world.method_8320(bp);
            if (!posState.method_26234((class_1922)world, bp) || !(random.method_43057() < config.chance)) continue;
            int thisHeight = Support.getRandomBetween(random, config.minHeight, config.maxHeight);
            for (int i = 1; i < thisHeight + 1 && world.method_8320(bp.method_10086(i)).method_26215(); ++i) {
                class_2680 placementBlockState = config.block;
                if (i == 1 && config.firstBlock != null) {
                    placementBlockState = config.firstBlock;
                } else if (i == thisHeight && config.lastBlock != null) {
                    placementBlockState = config.lastBlock;
                }
                world.method_8652(bp.method_10084(), placementBlockState, 3);
            }
        }
        return true;
    }
}

