/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.data_loaders.WeightedBlockGroupDataLoader;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_3545;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class BeeHiveSphere
extends Sphere<Config> {
    private static final String FLOWERS_GROUP = "flowers";
    private static final String TALL_FLOWERS_GROUP = "tall_flowers";

    public BeeHiveSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.shellThickness.method_35008((class_5819)random), config.flowerRingRadius.method_35008((class_5819)random), config.flowerRingSpacing.method_35008((class_5819)random));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final int shellThickness;
        private final int flowerRingRadius;
        private final int flowerRingSpacing;
        private final List<class_4482> outerBeehiveBlockEntities = new ArrayList<class_4482>();
        private class_4482 queenBeehiveBlockEntity;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, int shellThickness, int flowerRingRadius, int flowerRingSpacing) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.shellThickness = shellThickness;
            this.flowerRingRadius = flowerRingRadius;
            this.flowerRingSpacing = flowerRingSpacing;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            float endRingDistance = this.radius;
            float startRingDistance = this.radius - (float)this.flowerRingRadius;
            float shellDistance = startRingDistance - (float)this.flowerRingSpacing;
            float coreDistance = shellDistance - (float)this.shellThickness;
            class_2680 beeHiveBlockState = class_2246.field_20421.method_9564();
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if (d == 0L) {
                            chunk.method_12010((class_2338)currBlockPos, beeHiveBlockState, false);
                            this.queenBeehiveBlockEntity = new class_4482((class_2338)currBlockPos, beeHiveBlockState);
                            chunk.method_12007((class_2586)this.queenBeehiveBlockEntity);
                            continue;
                        }
                        if ((float)d <= coreDistance) {
                            int r = this.random.method_43048((int)Math.ceil(coreDistance / 3.0f));
                            if (coreDistance - (float)r <= (float)d) {
                                chunk.method_12010((class_2338)currBlockPos, class_2246.field_21211.method_9564(), false);
                                continue;
                            }
                            chunk.method_12010((class_2338)currBlockPos, class_2246.field_10124.method_9564(), false);
                            continue;
                        }
                        if ((float)d <= shellDistance) {
                            if (y2 - y == 0 && (double)((float)d - shellDistance) < -0.5 && this.random.method_43048(10) == 0) {
                                float xDist = x2 - x;
                                float zDist = z2 - z;
                                class_2350 direction = xDist > 0.0f ? (Math.abs(xDist) > Math.abs(zDist) ? class_2350.field_11034 : (zDist > 0.0f ? class_2350.field_11035 : class_2350.field_11043)) : (Math.abs(xDist) < Math.abs(zDist) ? (zDist > 0.0f ? class_2350.field_11035 : class_2350.field_11043) : class_2350.field_11039);
                                class_2680 blockState = (class_2680)class_2246.field_20421.method_9564().method_11657((class_2769)class_4481.field_20419, (Comparable)direction);
                                chunk.method_12010((class_2338)currBlockPos, blockState, false);
                                class_4482 outerBeehiveBlockEntity = new class_4482((class_2338)currBlockPos, blockState);
                                chunk.method_12007((class_2586)outerBeehiveBlockEntity);
                                this.outerBeehiveBlockEntities.add(outerBeehiveBlockEntity);
                                continue;
                            }
                            if (this.random.method_43048(10) == 0) {
                                chunk.method_12010((class_2338)currBlockPos, class_2246.field_21211.method_9564(), false);
                                continue;
                            }
                            chunk.method_12010((class_2338)currBlockPos, class_2246.field_21212.method_9564(), false);
                            continue;
                        }
                        if (y - y2 != 0 || !((float)d > startRingDistance) || !((float)d <= endRingDistance)) continue;
                        chunk.method_12010((class_2338)currBlockPos, class_2246.field_10219.method_9564(), false);
                        int rand = this.random.method_43048(4);
                        if (rand == 0) {
                            chunk.method_12010(currBlockPos.method_10084(), this.getRandomFlower(this.random), false);
                            continue;
                        }
                        if (rand != 1) continue;
                        class_2680 randomTallFlower = this.getRandomTallFlower(registryManager, this.random, (class_2338)currBlockPos);
                        chunk.method_12010(currBlockPos.method_10084(), (class_2680)randomTallFlower.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607), false);
                        chunk.method_12010(currBlockPos.method_10086(2), (class_2680)randomTallFlower.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609), false);
                    }
                }
            }
        }

        public class_2680 getRandomFlower(class_2919 random) {
            return WeightedBlockGroupDataLoader.INSTANCE.getEntry(BeeHiveSphere.FLOWERS_GROUP, (class_5819)random);
        }

        public class_2680 getRandomTallFlower(class_5455 registryManager, class_2919 random, class_2338 pos) {
            return WeightedBlockGroupDataLoader.INSTANCE.getEntry(BeeHiveSphere.TALL_FLOWERS_GROUP, (class_5819)random);
        }

        @Override
        public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
            super.populateEntities(chunkPos, chunkRegion, chunkRandom);
            if (this.isCenterInChunk(chunkPos)) {
                if (this.queenBeehiveBlockEntity != null) {
                    this.queenBeehiveBlockEntity.method_35292(this.getBee());
                }
                for (class_4482 beehiveBlockEntity : this.outerBeehiveBlockEntities) {
                    int beeCount = 2 + this.random.method_43048(2);
                    for (int j = 0; j < beeCount; ++j) {
                        beehiveBlockEntity.method_35292(this.getBee());
                    }
                }
            }
        }

        public class_4482.class_9309 getBee() {
            return class_4482.class_9309.method_57584((int)this.random.method_43048(599));
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ BeeHiveSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nShellRadius: " + this.shellThickness + "\nFlowerRingRadius: " + this.flowerRingRadius + "\nFlowerRingSpacing: " + this.flowerRingSpacing;
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness), (App)class_6017.field_33451.fieldOf("flower_ring_radius").forGetter(config -> config.shellThickness), (App)class_6017.field_33451.fieldOf("flower_ring_spacing").forGetter(config -> config.shellThickness)).apply((Applicative)instance, (sphereConfig, shellThickness, flowerRingRadius, flowerRingSpacing) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (class_6017)shellThickness, (class_6017)flowerRingRadius, (class_6017)flowerRingSpacing)));
        protected final class_6017 shellThickness;
        protected final class_6017 flowerRingRadius;
        protected final class_6017 flowerRingSpacing;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, class_6017 shellThickness, class_6017 flowerRingRadius, class_6017 flowerRingSpacing) {
            super(size, decorators, spawns, generation);
            this.shellThickness = shellThickness;
            this.flowerRingRadius = flowerRingRadius;
            this.flowerRingSpacing = flowerRingSpacing;
        }
    }
}

