/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class OceanMonumentSphere
extends Sphere<Config> {
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2680 PRISMARINE = class_2246.field_10135.method_9564();
    private static final class_2680 PRISMARINE_BRICKS = class_2246.field_10006.method_9564();
    private static final class_2680 DARK_PRISMARINE = class_2246.field_10297.method_9564();
    private static final class_2680 SEA_LANTERN = class_2246.field_10174.method_9564();
    private static final class_2680 TREASURE = class_2246.field_10562.method_9564();

    public OceanMonumentSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.coreRadius.method_33920((class_5819)random), config.shellThickness.method_35008((class_5819)random));
    }

    public static class Placed
    extends PlacedSphere<Config> {
        private final float coreRadius;
        private final float shellRadius;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, float coreRadius, float shellRadius) {
            super(configuredSphere, radius, decorators, spawns, random);
            this.coreRadius = coreRadius;
            this.shellRadius = shellRadius;
        }

        @Override
        public void generate(class_2791 chunk, class_5455 registryManager) {
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            this.random.method_43052((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            class_2338 spherePos = this.getPosition();
            int x = spherePos.method_10263();
            int y = spherePos.method_10264();
            int z = spherePos.method_10260();
            int ceiledRadius = (int)Math.ceil(this.radius);
            int maxX = Math.min(chunkX * 16 + 15, x + ceiledRadius);
            int maxZ = Math.min(chunkZ * 16 + 15, z + ceiledRadius);
            float shellDistance = this.radius - this.shellRadius;
            class_2338.class_2339 currBlockPos = new class_2338.class_2339();
            for (int x2 = Math.max(chunkX * 16, x - ceiledRadius); x2 <= maxX; ++x2) {
                for (int y2 = y - ceiledRadius; y2 <= y + ceiledRadius; ++y2) {
                    for (int z2 = Math.max(chunkZ * 16, z - ceiledRadius); z2 <= maxZ; ++z2) {
                        long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                        if ((float)d > this.radius) continue;
                        currBlockPos.method_10103(x2, y2, z2);
                        if ((float)d <= this.coreRadius) {
                            chunk.method_12010((class_2338)currBlockPos, TREASURE, false);
                            continue;
                        }
                        if ((float)d < this.coreRadius + 3.0f) {
                            chunk.method_12010((class_2338)currBlockPos, WATER, false);
                            continue;
                        }
                        if ((float)d == this.coreRadius + 3.0f) {
                            if (Math.abs(x2 - x) < 2 || Math.abs(z2 - z) < 2) {
                                chunk.method_12010((class_2338)currBlockPos, WATER, false);
                                continue;
                            }
                            chunk.method_12010((class_2338)currBlockPos, DARK_PRISMARINE, false);
                            continue;
                        }
                        if ((float)d <= shellDistance) {
                            if (y2 % 10 == 0 || x2 % 10 == 0 || z2 % 10 == 0) {
                                if ((y2 - y) % 6 == 0 && ((x2 - x) % 4 == 2 || (z2 - z) % 4 == 0)) {
                                    chunk.method_12010((class_2338)currBlockPos, SEA_LANTERN, false);
                                    continue;
                                }
                                chunk.method_12010((class_2338)currBlockPos, PRISMARINE_BRICKS, false);
                                continue;
                            }
                            chunk.method_12010((class_2338)currBlockPos, WATER, false);
                            continue;
                        }
                        if (y2 % 2 == 0) {
                            chunk.method_12010((class_2338)currBlockPos, PRISMARINE, false);
                            continue;
                        }
                        chunk.method_12010((class_2338)currBlockPos, PRISMARINE_BRICKS, false);
                    }
                }
            }
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ OceanMonumentSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nCoreRadius: " + this.coreRadius + "\nShellRadius: " + this.shellRadius;
        }

        @Override
        public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
            super.populateEntities(chunkPos, chunkRegion, chunkRandom);
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int iRadius = (int)this.radius - 5;
            for (int x2 = this.position.method_10263() - iRadius; x2 <= this.position.method_10263() + iRadius; x2 += 10) {
                for (int y2 = this.position.method_10264() - iRadius; y2 <= this.position.method_10264() + iRadius; y2 += 10) {
                    for (int z2 = this.position.method_10260() - iRadius; z2 <= this.position.method_10260() + iRadius; z2 += 10) {
                        long d = Math.round(Support.getDistance(this.position.method_10263(), this.position.method_10264(), this.position.method_10260(), x2, y2, z2));
                        if (!((float)d < this.radius - this.shellRadius)) continue;
                        mutable.method_10103(x2, y2, z2);
                        if (!Support.isBlockPosInChunkPos(chunkPos, (class_2338)mutable) || !this.spawnGuardian(chunkPos, chunkRegion, (class_2338)mutable)) continue;
                        return;
                    }
                }
            }
        }

        private boolean spawnGuardian(class_1923 chunkPos, class_3233 chunkRegion, class_2338 guardianPosition) {
            class_1308 mobentity = (double)this.random.method_43057() < 0.08 ? (class_1308)class_1299.field_6086.method_5883((class_1937)chunkRegion.method_8410(), class_3730.field_16472) : (class_1308)class_1299.field_6118.method_5883((class_1937)chunkRegion.method_8410(), class_3730.field_16472);
            if (mobentity != null) {
                float width = mobentity.method_17681();
                double xLength = class_3532.method_15350((double)guardianPosition.method_10263(), (double)((double)chunkPos.method_8326() + (double)width), (double)((double)chunkPos.method_8326() + 16.0 - (double)width));
                double zLength = class_3532.method_15350((double)guardianPosition.method_10260(), (double)((double)chunkPos.method_8328() + (double)width), (double)((double)chunkPos.method_8328() + 16.0 - (double)width));
                try {
                    mobentity.method_5808(xLength, (double)guardianPosition.method_10264(), zLength, this.random.method_43057() * 360.0f, 0.0f);
                    mobentity.method_5971();
                    if (mobentity.method_5979((class_1936)chunkRegion, class_3730.field_16472) && mobentity.method_5957((class_4538)chunkRegion)) {
                        mobentity.method_5943((class_5425)chunkRegion, chunkRegion.method_8404(mobentity.method_24515()), class_3730.field_16472, null);
                        boolean success = chunkRegion.method_8649((class_1297)mobentity);
                        if (!success) {
                            return true;
                        }
                    }
                }
                catch (Exception exception) {
                    StarrySkies.LOGGER.warn("Failed to spawn mob on sphere {}\nException: {}", (Object)this.getDescription(chunkRegion.method_30349()), (Object)exception);
                }
            }
            return false;
        }
    }

    public static class Config
    extends SphereConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)class_5863.method_33916((float)1.0f, (float)32.0f).fieldOf("core_radius").forGetter(config -> config.coreRadius), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness)).apply((Applicative)instance, (sphereConfig, coreRadius, shellThickness) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (class_5863)coreRadius, (class_6017)shellThickness)));
        protected final class_5863 coreRadius;
        protected final class_6017 shellThickness;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, class_5863 coreRadius, class_6017 shellThickness) {
            super(size, decorators, spawns, generation);
            this.coreRadius = coreRadius;
            this.shellThickness = shellThickness;
        }
    }
}

