/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.advancements;

import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.advancements.StarryAdvancementCriteria;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ProximityAdvancementCheckEvent
implements ServerTickEvents.EndTick {
    private static final int ADVANCEMENT_CHECK_TICKS = 100;
    private static int tickCounter;

    public void onEndTick(MinecraftServer minecraftServer) {
        if (++tickCounter % 100 == 0) {
            tickCounter = 0;
            StarrySkies.LOGGER.debug("Advancement check start. Players: {}", (Object)minecraftServer.method_3760().method_14574());
            for (class_3222 serverPlayerEntity : minecraftServer.method_3760().method_14571()) {
                StarrySkies.LOGGER.debug("Checking player {}", (Object)serverPlayerEntity.method_5477());
                if (!StarrySkies.isStarryWorld(serverPlayerEntity.method_51469())) continue;
                StarrySkies.LOGGER.debug("In starry world");
                Optional<Support.SphereDistance> distance = Support.getClosestSphere(serverPlayerEntity.method_51469(), serverPlayerEntity.method_24515());
                if (!distance.isPresent() || !(Math.sqrt(distance.get().squaredDistance) < (double)(distance.get().sphere.getRadius() + 2))) continue;
                PlacedSphere<?> sphere = distance.get().sphere;
                StarryAdvancementCriteria.SPHERE_DISCOVERED.trigger(serverPlayerEntity, sphere);
            }
        }
    }
}

