/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.starryskies.StarrySkies;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class UniqueBlockGroupDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String LOCATION = "starry_skies/unique_block_group";
    public static final class_2960 ID = StarrySkies.id("starry_skies/unique_block_group");
    public static final UniqueBlockGroupDataLoader INSTANCE = new UniqueBlockGroupDataLoader();
    protected static final Map<String, class_2248> GROUPS = new Object2ObjectArrayMap();

    private UniqueBlockGroupDataLoader() {
        super(new Gson(), LOCATION);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject o = jsonElement.getAsJsonObject();
            String group = o.get("group").getAsString();
            if (GROUPS.containsKey(group)) {
                return;
            }
            JsonArray blockArray = o.get("blocks").getAsJsonArray();
            Iterator iterator = blockArray.iterator();
            if (iterator.hasNext()) {
                JsonElement e = (JsonElement)iterator.next();
                class_2960 id = class_2960.method_12829((String)e.getAsString());
                Optional optionalBlock = class_7923.field_41175.method_17966(id);
                optionalBlock.ifPresent(block -> GROUPS.put(group, (class_2248)block));
                return;
            }
        });
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public class_2248 get(String id) {
        return GROUPS.get(id);
    }

    public class_2680 getEntry(String group, class_5819 random) {
        class_2248 block = INSTANCE.get(group);
        if (block == null) {
            StarrySkies.LOGGER.warn("Trying to query a nonexistent UniqueBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        return block.method_9564();
    }
}

