/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class WeightedBlockGroupDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String LOCATION = "starry_skies/weighted_block_group";
    public static final class_2960 ID = StarrySkies.id("starry_skies/weighted_block_group");
    public static final WeightedBlockGroupDataLoader INSTANCE = new WeightedBlockGroupDataLoader();
    protected static final Map<String, Map<class_2248, Float>> GROUPS = new Object2ObjectArrayMap();

    private WeightedBlockGroupDataLoader() {
        super(new Gson(), LOCATION);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject o = jsonElement.getAsJsonObject();
            String group = o.get("group").getAsString();
            JsonObject blockArray = o.get("blocks").getAsJsonObject();
            for (Map.Entry e : blockArray.asMap().entrySet()) {
                class_2960 id = class_2960.method_12829((String)((String)e.getKey()));
                Optional optionalBlock = class_7923.field_41175.method_17966(id);
                if (!optionalBlock.isPresent()) continue;
                class_2248 block = (class_2248)optionalBlock.get();
                float weight = ((JsonElement)e.getValue()).getAsFloat();
                GROUPS.computeIfAbsent(group, k -> new Object2FloatArrayMap()).put(block, Float.valueOf(weight));
            }
        });
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Map<class_2248, Float> get(String blockGroup) {
        return GROUPS.get(blockGroup);
    }

    public class_2680 getEntry(String group, class_5819 random) {
        Map<class_2248, Float> weightedBlocks = this.get(group);
        if (weightedBlocks == null) {
            StarrySkies.LOGGER.warn("Trying to query a nonexistent WeightedBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        if (weightedBlocks.isEmpty()) {
            StarrySkies.LOGGER.warn("Trying to query an empty WeightedBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        return Support.getWeightedRandom(weightedBlocks, random).method_9564();
    }
}

