/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.registries.StarryRegistryKeys;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemGenerator {
    public static final Codec<SystemGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spheres_per_system").forGetter(generator -> generator.spheresPerSystem), (App)Codec.INT.fieldOf("min_distance_between_spheres").forGetter(generator -> generator.minDistanceBetweenSpheres), (App)Codec.INT.fieldOf("floor_height").forGetter(generator -> generator.floorHeight), (App)class_2680.field_24734.fieldOf("floor_state").forGetter(generator -> generator.floorState), (App)class_2680.field_24734.fieldOf("bottom_state").forGetter(generator -> generator.bottomState), (App)DefaultSphere.CODEC.listOf().fieldOf("fixed_spheres").forGetter(generator -> generator.defaultSpheres)).apply((Applicative)instance, SystemGenerator::new));
    private final int spheresPerSystem;
    private final int minDistanceBetweenSpheres;
    private final int floorHeight;
    private final class_2680 floorState;
    private final class_2680 bottomState;
    private final List<DefaultSphere> defaultSpheres;
    private final Map<Map<ConfiguredSphere<?, ?>, Float>, Float> generationGroups = new Object2FloatArrayMap();
    private final Map<Point, System> systemCache = new Object2ObjectArrayMap();

    public SystemGenerator(int spheresPerSystem, int minDistanceBetweenSpheres, int floorHeight, class_2680 floorState, class_2680 bottomState, List<DefaultSphere> defaultSpheres) {
        this.spheresPerSystem = spheresPerSystem;
        this.minDistanceBetweenSpheres = minDistanceBetweenSpheres;
        this.floorHeight = floorHeight;
        this.floorState = floorState;
        this.bottomState = bottomState;
        this.defaultSpheres = defaultSpheres;
    }

    public void addGenerationGroup(Map<ConfiguredSphere<?, ?>, Float> weightedSpheres, float weight) {
        this.generationGroups.put(weightedSpheres, Float.valueOf(weight));
    }

    public int getFloorHeight() {
        return this.floorHeight;
    }

    public class_2680 getSeaBlock(int heightY) {
        if (heightY == 0) {
            return this.bottomState;
        }
        return this.floorState;
    }

    public System getSystem(class_1936 worldAccess, long seed, int chunkX, int chunkZ) {
        Point systemPos = Support.getSystemCoordinateFromChunkCoordinate(chunkX, chunkZ);
        return this.getSystem(worldAccess, seed, systemPos);
    }

    public System getSystem(class_5281 world, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        Point systemPos = Support.getSystemCoordinateFromChunkCoordinate(chunkPos.field_9181, chunkPos.field_9180);
        return this.getSystem((class_1936)world, world.method_8412(), systemPos);
    }

    public System getSystem(class_5281 world, Point systemPos) {
        System system = this.systemCache.get(systemPos);
        if (system == null) {
            system = System.generateSystem(this, world.method_31607(), world.method_31605(), world.method_8412(), systemPos, world.method_30349());
            this.systemCache.put(systemPos, system);
        }
        return system;
    }

    public System getSystem(class_1936 worldAccess, long seed, Point systemPos) {
        System system = this.systemCache.get(systemPos);
        if (system == null) {
            system = System.generateSystem(this, worldAccess.method_31607(), worldAccess.method_31605(), seed, systemPos, worldAccess.method_30349());
            this.systemCache.put(systemPos, system);
        }
        return system;
    }

    public Iterable<? extends PlacedSphere<?>> getSystem(class_2791 chunk, long seed, class_5455 registryManager) {
        Point systemPos = Support.getSystemCoordinateFromChunkCoordinate(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        System system = this.systemCache.get(systemPos);
        if (system == null) {
            system = System.generateSystem(this, chunk.method_31607(), chunk.method_31605(), seed, systemPos, registryManager);
            this.systemCache.put(systemPos, system);
        }
        return system;
    }

    public record System(List<PlacedSphere<?>> spheres) implements Iterable<PlacedSphere<?>>
    {
        private static System generateSystem(SystemGenerator systemGenerator, int bottomY, int worldHeight, long seed, @NotNull Point systemPoint, class_5455 registryManager) {
            int systemPointX = systemPoint.x;
            int systemPointZ = systemPoint.y;
            class_2919 systemRandom = System.getSystemRandom(systemPoint, seed);
            List<PlacedSphere<?>> defaultSpheres = System.getDefaultSpheres(systemGenerator, systemPointX, systemPointZ, systemRandom, registryManager);
            ArrayList spheresInSystem = new ArrayList(defaultSpheres);
            for (int currentDensity = 0; currentDensity < systemGenerator.spheresPerSystem; ++currentDensity) {
                @Nullable PlacedSphere<?> currentSphere = System.getRandomSphere(systemGenerator, systemRandom, systemPoint, registryManager, bottomY, worldHeight, spheresInSystem);
                if (currentSphere == null) continue;
                spheresInSystem.add(currentSphere);
            }
            StarrySkies.LOGGER.debug("Created a new system with {} spheres at system position {},{}", new Object[]{spheresInSystem.size(), systemPointX, systemPointZ});
            return new System(spheresInSystem);
        }

        @NotNull
        private static class_2919 getSystemRandom(@NotNull Point systemPoint, long seed) {
            class_2919 systemRandom = new class_2919((class_5819)new class_5820(seed));
            systemRandom.method_12663(seed, systemPoint.x, systemPoint.y);
            return systemRandom;
        }

        private static List<PlacedSphere<?>> getDefaultSpheres(SystemGenerator systemGenerator, int systemPointX, int systemPointZ, class_2919 systemRandom, class_5455 registryManager) {
            if (systemGenerator.defaultSpheres.isEmpty()) {
                return List.of();
            }
            class_2378 templateRegistry = registryManager.method_30530(StarryRegistryKeys.CONFIGURED_SPHERE);
            ArrayList defaultSpheres = new ArrayList();
            for (DefaultSphere defaultSphere : systemGenerator.defaultSpheres) {
                ConfiguredSphere template;
                if (systemPointX != defaultSphere.systemX || systemPointZ != defaultSphere.systemZ || (template = (ConfiguredSphere)templateRegistry.method_10223(defaultSphere.sphereId)) == null) continue;
                class_2338 pos = new class_2338(defaultSphere.x, defaultSphere.y, defaultSphere.z);
                PlacedSphere<?> sphere = template.generate(systemRandom, registryManager, pos, template.getSize(systemRandom));
                sphere.setPosition(new class_2338(defaultSphere.x, defaultSphere.y, defaultSphere.z));
                defaultSpheres.add(sphere);
            }
            return defaultSpheres;
        }

        @Nullable
        private static PlacedSphere<?> getRandomSphere(SystemGenerator systemGenerator, class_2919 systemRandom, @NotNull Point systemPoint, class_5455 registryManager, int bottomY, int worldHeight, List<PlacedSphere<?>> spheresInSystem) {
            PlacedSphere<?> placed;
            int systemSizeChunks = StarrySkies.CONFIG.systemSizeChunks;
            while (true) {
                Map<ConfiguredSphere<?, ?>, Float> spheresInSelectedGroup;
                if ((spheresInSelectedGroup = Support.getWeightedRandom(systemGenerator.generationGroups, (class_5819)systemRandom)).isEmpty()) {
                    return null;
                }
                ConfiguredSphere<?, ?> selectedSphere = Support.getWeightedRandom(spheresInSelectedGroup, (class_5819)systemRandom);
                if (selectedSphere == null) continue;
                StarrySkies.LOGGER.debug("Created a new sphere of type {} Next random: {}", selectedSphere, (Object)systemRandom.method_43054());
                float radius = selectedSphere.getSize(systemRandom);
                int iRadius = (int)radius;
                int xPos = Support.getRandomBetween((class_5819)systemRandom, iRadius, systemSizeChunks * 16 - iRadius);
                int zPos = Support.getRandomBetween((class_5819)systemRandom, iRadius, systemSizeChunks * 16 - iRadius);
                int yPos = bottomY + systemGenerator.floorHeight + iRadius + systemRandom.method_43048(worldHeight - iRadius * 2 - systemGenerator.floorHeight);
                class_2338 spherePos = new class_2338(xPos += systemSizeChunks * 16 * systemPoint.x, yPos, zPos += systemSizeChunks * 16 * systemPoint.y);
                placed = selectedSphere.generate(systemRandom, registryManager, spherePos, radius);
                placed.setPosition(spherePos);
                for (PlacedSphere<?> sphere : spheresInSystem) {
                    int distMin = sphere.getRadius() + iRadius + systemGenerator.minDistanceBetweenSpheres;
                    double distSquared = spherePos.method_10262((class_2382)sphere.getPosition());
                    if (!(distSquared < (double)(distMin * distMin))) continue;
                    placed = null;
                    break;
                }
                if (placed != null) break;
            }
            return placed;
        }

        @Override
        @NotNull
        public Iterator<PlacedSphere<?>> iterator() {
            return this.spheres.iterator();
        }
    }

    public record DefaultSphere(int systemX, int systemZ, int x, int y, int z, class_2960 sphereId) {
        public static final Codec<DefaultSphere> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("system_x").forGetter(s -> s.systemX), (App)Codec.INT.fieldOf("system_y").forGetter(s -> s.systemZ), (App)Codec.INT.fieldOf("x").forGetter(s -> s.x), (App)Codec.INT.fieldOf("y").forGetter(s -> s.y), (App)Codec.INT.fieldOf("z").forGetter(s -> s.z), (App)class_2960.field_25139.fieldOf("sphere_id").forGetter(s -> s.sphereId)).apply((Applicative)instance, DefaultSphere::new));
    }
}

