/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.salju.supernatural.entity.Angel;
import net.salju.supernatural.init.SupernaturalMobs;

public class AngelItem
extends Item {
    public AngelItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace().equals((Object)Direction.DOWN)) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            BlockPos pos = new BlockPlaceContext(context).getClickedPos();
            AABB nums = ((EntityType)SupernaturalMobs.ANGEL.get()).getDimensions().makeBoundingBox(Vec3.atBottomCenterOf((Vec3i)pos).x(), Vec3.atBottomCenterOf((Vec3i)pos).y(), Vec3.atBottomCenterOf((Vec3i)pos).z());
            Consumer consumer = EntityType.createDefaultStackConfig((Level)lvl, (ItemStack)context.getItemInHand(), (LivingEntity)context.getPlayer());
            Angel target = (Angel)((EntityType)SupernaturalMobs.ANGEL.get()).create(lvl, consumer, pos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
            if (target != null && lvl.noCollision((Entity)target, nums) && lvl.getEntities((Entity)target, nums).isEmpty()) {
                float rot = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                target.snapTo(target.getX(), target.getY(), target.getZ(), rot, 0.0f);
                lvl.addFreshEntityWithPassengers((Entity)target);
                lvl.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                target.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
                context.getItemInHand().shrink(1);
                context.getPlayer().swing(context.getHand(), true);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

