/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.item.component.RitualBookData;

public class RitualBookItem
extends Item {
    public RitualBookItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, list, flag);
        if (flag.hasShiftDown()) {
            RitualBookData data = (RitualBookData)stack.get(SupernaturalData.BOOK);
            if (data != null) {
                list.accept((Component)Component.translatable((String)("desc.book.page_" + data.getPage())).withStyle(ChatFormatting.BLUE));
                list.accept((Component)Component.translatable((String)("desc.book.desc_" + data.getPage())).withStyle(ChatFormatting.GRAY));
                list.accept((Component)Component.empty());
                list.accept((Component)Component.translatable((String)data.getRequiredItem()).withStyle(ChatFormatting.GRAY));
                list.accept((Component)Component.translatable((String)data.getSoulPower()).withStyle(ChatFormatting.DARK_PURPLE));
                list.accept((Component)Component.literal((String)data.getCandles()).withStyle(ChatFormatting.GOLD));
            }
            list.accept((Component)Component.empty());
            list.accept((Component)Component.translatable((String)"desc.book.wheel").withStyle(ChatFormatting.GRAY));
        } else {
            list.accept((Component)Component.translatable((String)"desc.book.shift").withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(SupernaturalData.BOOK, (Object)RitualBookData.EMPTY);
        return stack;
    }
}

