/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.compass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.item.component.RitualCompassData;

public class RitualCompassState
extends NeedleDirectionHelper {
    public static final MapCodec<RitualCompassState> MAP_CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)Boolean.TRUE).forGetter(rec$ -> ((RitualCompassState)((Object)((Object)((Object)rec$)))).wobble())).apply((Applicative)codec, RitualCompassState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);
    private final RandomSource random = RandomSource.create();

    public RitualCompassState(boolean check) {
        super(check);
    }

    protected float calculate(ItemStack stack, ClientLevel lvl, int i, Entity target) {
        RitualCompassData data = (RitualCompassData)stack.get(SupernaturalData.COMPASS);
        GlobalPos pos = null;
        if (data != null && data.target().isPresent()) {
            pos = data.target().get();
        }
        return RitualCompassState.isValid(target, pos) ? this.getTarget(target, lvl.getGameTime(), pos.pos()) : this.getRandom(i, lvl.getGameTime());
    }

    private float getRandom(int i, long time) {
        if (this.wobbler.shouldUpdate(time)) {
            this.wobbler.update(time, this.random.nextFloat());
        }
        return Mth.positiveModulo((float)(this.wobbler.rotation() + (float)RitualCompassState.hash(i) / 2.1474836E9f), (float)1.0f);
    }

    private float getTarget(Entity target, long time, BlockPos pos) {
        Player player;
        float a = (float)RitualCompassState.getAngle(target, pos);
        float y = RitualCompassState.getRotY(target);
        if (target instanceof Player && (player = (Player)target).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(time)) {
                this.wobbler.update(time, 0.5f - (y - 0.25f));
            }
            return Mth.positiveModulo((float)(a + this.wobbler.rotation()), (float)1.0f);
        }
        return Mth.positiveModulo((float)(0.5f - (y - 0.25f - a)), (float)1.0f);
    }

    private static boolean isValid(Entity target, @Nullable GlobalPos pos) {
        return pos != null && pos.dimension().equals(target.level().dimension()) && !(pos.pos().distToCenterSqr((Position)target.position()) < (double)1.0E-5f);
    }

    private static double getAngle(Entity target, BlockPos pos) {
        return Math.atan2(Vec3.atCenterOf((Vec3i)pos).z() - target.getZ(), Vec3.atCenterOf((Vec3i)pos).x() - target.getX()) / 6.2831854820251465;
    }

    private static float getRotY(Entity target) {
        return Mth.positiveModulo((float)(target.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int i) {
        return i * 1327217883;
    }
}

