/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.supernatural.entity.ai.spells.SupernaturalBloodSpellGoal;
import net.salju.supernatural.entity.ai.spells.SupernaturalSpellcasterGoal;
import net.salju.supernatural.entity.ai.targets.VampireAttackSelector;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalDamageTypes;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalSounds;

public class AbstractVampireEntity
extends SpellcasterIllager {
    public AbstractVampireEntity(EntityType<? extends AbstractVampireEntity> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
        this.getNavigation().setCanOpenDoors(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new SupernaturalSpellcasterGoal((Monster)this));
        this.goalSelector.addGoal(2, (Goal)new SupernaturalBloodSpellGoal((Monster)this));
        this.goalSelector.addGoal(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new Raider.HoldGroundAttackGoal((AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, false, (TargetingConditions.Selector)new VampireAttackSelector((AbstractIllager)this)));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    public boolean doHurtTarget(ServerLevel lvl, Entity entity) {
        Player player;
        if (entity instanceof Player && !SupernaturalManager.isVampire((LivingEntity)(player = (Player)entity)) && Math.random() <= (Double)SupernaturalConfig.ATTACKED.get()) {
            player.addEffect(new MobEffectInstance(SupernaturalEffects.VAMPIRISM, 24000, 0));
        }
        return super.doHurtTarget(lvl, entity);
    }

    protected void customServerAiStep(ServerLevel lvl) {
        if (!this.isNoAi() && GoalUtils.hasGroundPathNavigation((Mob)this)) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(lvl.isRaided(this.blockPosition()));
        }
        if (this.isCastingSpell()) {
            this.navigation.stop();
        }
        super.customServerAiStep(lvl);
    }

    public void aiStep() {
        if (this.isAlive() && !((Boolean)SupernaturalConfig.SUN.get()).booleanValue() && this.isSunBurnTick() && !this.hasEffect(MobEffects.FIRE_RESISTANCE) && this.getRemainingFireTicks() <= 20) {
            this.setRemainingFireTicks(120);
            this.hurt(SupernaturalDamageTypes.causeSunDamage(this.level().registryAccess()), 3.0f);
        }
        super.aiStep();
    }

    public void setIsCastingSpell(int i) {
        if (i == 0) {
            this.setIsCastingSpell(SpellcasterIllager.IllagerSpell.NONE);
        } else if (i == 1) {
            this.setIsCastingSpell(SpellcasterIllager.IllagerSpell.SUMMON_VEX);
        } else if (i == 2) {
            this.setIsCastingSpell(SpellcasterIllager.IllagerSpell.FANGS);
        }
    }

    public void setSpellCastingTime(int i) {
        this.spellCastingTickCount = i;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public boolean removeWhenFarAway(double d) {
        return false;
    }

    public void applyRaidBuffs(ServerLevel lvl, int i, boolean check) {
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SupernaturalSounds.VAMPIRE_IDLE.get();
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SupernaturalSounds.VAMPIRE_HURT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)SupernaturalSounds.VAMPIRE_DEATH.get();
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)SupernaturalSounds.VAMPIRE_CELEBRATE.get();
    }

    public SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }
}

