/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.targets;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.salju.supernatural.entity.AbstractMinionEntity;
import net.salju.supernatural.init.SupernaturalTags;

public class MinionAttackSelector
implements TargetingConditions.Selector {
    private final AbstractMinionEntity armor;

    public MinionAttackSelector(AbstractMinionEntity source) {
        this.armor = source;
    }

    public boolean test(@Nullable LivingEntity target, ServerLevel lvl) {
        if (this.armor.isTamed() && this.armor.getOwner() != null && target != null) {
            Entity ent = this.armor.level().getEntity(this.armor.getOwner().getUUID());
            if (ent instanceof Player) {
                Player player = (Player)ent;
                if (player.getLastHurtByMob() != null && player.getLastHurtByMob().isAlive()) {
                    return target.equals((Object)player.getLastHurtByMob());
                }
                if (player.getLastHurtMob() != null && player.getLastHurtMob().isAlive()) {
                    return target.equals((Object)player.getLastHurtMob());
                }
                return target.getType().is(SupernaturalTags.ARMOR);
            }
            if (ent instanceof Mob) {
                Mob bob = (Mob)ent;
                if (bob.getLastHurtByMob() != null && bob.getLastHurtByMob().isAlive()) {
                    return target.equals((Object)bob.getLastHurtByMob());
                }
                if (bob.getTarget() != null && bob.getTarget().isAlive()) {
                    return target.equals((Object)bob.getTarget());
                }
            }
        }
        return target instanceof Player;
    }
}

