/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.events;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.salju.supernatural.block.RitualBlockEntity;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalTags;
import net.salju.supernatural.item.component.SoulgemData;

public class SupernaturalManager {
    public static int getEnchantmentLevel(ItemStack stack, Level world, String id, String name) {
        return stack.getEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)name))));
    }

    public static boolean isVampire(LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.getPersistentData().getCompound("PlayerPersisted").isPresent()) {
                return ((CompoundTag)player.getPersistentData().getCompound("PlayerPersisted").get()).getBooleanOr("isVampire", false);
            }
            return false;
        }
        return target.getType().is(SupernaturalTags.VAMPIRE);
    }

    public static boolean hasVampirism(LivingEntity target) {
        return target.hasEffect(SupernaturalEffects.VAMPIRISM) && target.getEffect(SupernaturalEffects.VAMPIRISM).getAmplifier() >= 1;
    }

    public static void setVampire(Player player, boolean check) {
        if (player.getPersistentData().getCompound("PlayerPersisted").isEmpty()) {
            player.getPersistentData().put("PlayerPersisted", (Tag)new CompoundTag());
        }
        CompoundTag data = (CompoundTag)player.getPersistentData().getCompound("PlayerPersisted").get();
        if (!check) {
            data.remove("isVampire");
            player.getPersistentData().put("PlayerPersisted", (Tag)data);
            player.getAttributes().removeAttributeModifiers(SupernaturalManager.createSupernatural());
        } else {
            data.putBoolean("isVampire", true);
            player.getPersistentData().put("PlayerPersisted", (Tag)data);
        }
    }

    public static void addVampireEffects(Player player) {
        player.getAttributes().addTransientAttributeModifiers(SupernaturalManager.createSupernatural());
        player.addEffect(new MobEffectInstance(SupernaturalEffects.VAMPIRISM, 5, 4, false, false, false));
        if (player.isCrouching()) {
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 10, 0, false, false, false));
        }
    }

    private static Multimap<Holder<Attribute>, AttributeModifier> createSupernatural() {
        HashMultimap stats = HashMultimap.create();
        if ((Integer)SupernaturalConfig.DAMAGE.get() > 0) {
            stats.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"vdps"), (double)((Integer)SupernaturalConfig.DAMAGE.get()).intValue(), AttributeModifier.Operation.ADD_VALUE));
        }
        if ((Integer)SupernaturalConfig.SPEED.get() > 0) {
            stats.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"vspeed"), (double)((float)((Integer)SupernaturalConfig.SPEED.get()).intValue() / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        return stats;
    }

    public static ItemStack setSoul(ItemStack stack, LivingEntity target) {
        TagValueOutput mobster = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        target.save((ValueOutput)mobster);
        stack.set(SupernaturalData.SOULGEM, (Object)new SoulgemData(mobster.buildResult(), SupernaturalManager.getSoulLevel(target)));
        return stack;
    }

    public static CompoundTag getSoulTag(ItemStack stack) {
        SoulgemData data = (SoulgemData)stack.getOrDefault(SupernaturalData.SOULGEM, (Object)SoulgemData.EMPTY);
        return data.getSoul();
    }

    public static String getSoulLevel(LivingEntity target) {
        if (target.getType().is(SupernaturalTags.GRAND)) {
            return "soulgem.supernatural.grand";
        }
        if (target.getType().is(SupernaturalTags.GREATER)) {
            return "soulgem.supernatural.greater";
        }
        if (target.getType().is(SupernaturalTags.COMMON)) {
            return "soulgem.supernatural.common";
        }
        if (target.getType().is(SupernaturalTags.LESSER)) {
            return "soulgem.supernatural.lesser";
        }
        if (target.getType().is(SupernaturalTags.PETTY)) {
            return "soulgem.supernatural.petty";
        }
        if (target instanceof Monster) {
            return "soulgem.supernatural.common";
        }
        if (target instanceof Animal) {
            return "soulgem.supernatural.lesser";
        }
        return "soulgem.supernatural.petty";
    }

    public static int getSoulLevel(String str) {
        HashMap<String, Integer> soulMap = new HashMap<String, Integer>();
        soulMap.put("soulgem.supernatural.petty", 1);
        soulMap.put("soulgem.supernatural.lesser", 2);
        soulMap.put("soulgem.supernatural.common", 3);
        soulMap.put("soulgem.supernatural.greater", 4);
        soulMap.put("soulgem.supernatural.grand", 5);
        return soulMap.getOrDefault(str, 0);
    }

    public static String getSoulgem(ItemStack stack) {
        SoulgemData data = (SoulgemData)stack.getOrDefault(SupernaturalData.SOULGEM, (Object)SoulgemData.EMPTY);
        return data.getSoulPower();
    }

    @Nullable
    public static RitualBlockEntity getAltar(BlockPos pos, ServerLevel lvl, int r, Item i) {
        Stream stream = lvl.getPoiManager().getInRange(type -> type.is(SupernaturalBlocks.RITUAL_POI.getKey()), pos, r, PoiManager.Occupancy.ANY);
        for (PoiRecord record : stream.toList()) {
            RitualBlockEntity target;
            BlockEntity blockEntity = lvl.getBlockEntity(record.getPos());
            if (!(blockEntity instanceof RitualBlockEntity) || !(target = (RitualBlockEntity)blockEntity).getItem(0).is(i) || !pos.closerThan((Vec3i)record.getPos(), (double)r) || !SupernaturalManager.canRitualsWork(lvl, record.getPos(), target)) continue;
            return target;
        }
        return null;
    }

    public static boolean canRitualsWork(ServerLevel lvl, BlockPos pos, RitualBlockEntity target) {
        return lvl.dimensionType().natural() && !target.getGreedy() && lvl.getBrightness(LightLayer.BLOCK, pos) < 6 && (lvl.getBrightness(LightLayer.SKY, pos) < 6 || lvl.isDarkOutside());
    }

    public static int getPower(ServerLevel lvl, BlockPos pos) {
        int i = 0;
        List<BlockPos> list = SupernaturalManager.getCircle(pos);
        for (BlockPos poz : list) {
            BlockState state = lvl.getBlockState(poz);
            if (!(state.getBlock() instanceof CandleBlock) || !((Boolean)state.getValue((Property)CandleBlock.LIT)).booleanValue()) continue;
            i += ((Integer)state.getValue((Property)CandleBlock.CANDLES)).intValue();
            lvl.setBlock(poz, (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return Math.min(28, i);
    }

    public static List<BlockPos> getCircle(BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.north(4));
        list.add(pos.west(4));
        list.add(pos.south(4));
        list.add(pos.east(4));
        list.add(BlockPos.containing((double)(pos.getX() + 3), (double)pos.getY(), (double)(pos.getZ() + 2)));
        list.add(BlockPos.containing((double)(pos.getX() + 3), (double)pos.getY(), (double)(pos.getZ() - 2)));
        list.add(BlockPos.containing((double)(pos.getX() - 3), (double)pos.getY(), (double)(pos.getZ() + 2)));
        list.add(BlockPos.containing((double)(pos.getX() - 3), (double)pos.getY(), (double)(pos.getZ() - 2)));
        list.add(BlockPos.containing((double)(pos.getX() + 2), (double)pos.getY(), (double)(pos.getZ() + 3)));
        list.add(BlockPos.containing((double)(pos.getX() + 2), (double)pos.getY(), (double)(pos.getZ() - 3)));
        list.add(BlockPos.containing((double)(pos.getX() - 2), (double)pos.getY(), (double)(pos.getZ() + 3)));
        list.add(BlockPos.containing((double)(pos.getX() - 2), (double)pos.getY(), (double)(pos.getZ() - 3)));
        return list;
    }

    public static boolean hasArmor(LivingEntity target) {
        int i = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (target.getItemBySlot(slot).isEmpty()) continue;
            ++i;
        }
        return i >= 4;
    }

    public static <T extends Mob> T convertArmor(ArmorStand target, EntityType<T> type, boolean equip) {
        Mob armor = (Mob)type.create(target.level(), EntitySpawnReason.CONVERSION);
        armor.copyPosition((Entity)target);
        if (target.hasCustomName()) {
            armor.setCustomName(target.getCustomName());
            armor.setCustomNameVisible(target.isCustomNameVisible());
        }
        armor.setPersistenceRequired();
        armor.addEffect(new MobEffectInstance(SupernaturalEffects.POSSESSION, 999999, 0));
        armor.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        armor.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        if (equip) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = target.getItemBySlot(slot);
                if (stack.isEmpty()) continue;
                armor.setItemSlot(slot, stack.copy());
                armor.setDropChance(slot, 1.0f);
                stack.setCount(0);
            }
        }
        target.level().addFreshEntity((Entity)armor);
        target.discard();
        return (T)armor;
    }
}

