/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalItems;

public class Angel
extends Mob {
    public static final EntityDataAccessor<Integer> POSE = SynchedEntityData.defineId(Angel.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> CURSED = SynchedEntityData.defineId(Angel.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Angel(EntityType<Angel> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Angel", this.getAngelPose());
        tag.putBoolean("Cursed", this.isCursed());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.getEntityData().set(POSE, (Object)tag.getInt("Angel"));
        this.getEntityData().set(CURSED, (Object)tag.getBoolean("Cursed"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(POSE, (Object)1);
        builder.define(CURSED, (Object)false);
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() instanceof PickaxeItem && !this.isCursed()) {
            if (player.isCrouching()) {
                if (this.getAngelPose() >= 7) {
                    this.getEntityData().set(POSE, (Object)1);
                } else {
                    this.getEntityData().set(POSE, (Object)(this.getAngelPose() + 1));
                }
            } else {
                float rot = (float)Mth.floor((float)((Mth.wrapDegrees((float)(player.getYRot() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                this.setYRot(rot);
                this.setYBodyRot(rot);
                this.setYHeadRot(rot);
                this.yRotO = rot;
                this.yBodyRotO = rot;
                this.yHeadRotO = rot;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity target;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).getMainHandItem().getItem() instanceof PickaxeItem && !this.isCursed() || source.is(DamageTypes.FELL_OUT_OF_WORLD) || source.is(DamageTypes.EXPLOSION) || source.isCreativePlayer() || source.getEntity() instanceof Creeper) {
            return super.hurt(source, amount);
        }
        return false;
    }

    public void die(DamageSource source) {
        super.die(source);
        this.showBreakingParticles();
        this.discard();
    }

    public void baseTick() {
        block15: {
            super.baseTick();
            Level level = this.level();
            if (!(level instanceof ServerLevel)) break block15;
            ServerLevel lvl = (ServerLevel)level;
            if (this.isAlive() && this.isEffectiveAi()) {
                if (this.isCursed()) {
                    Player player = lvl.getNearestPlayer((Entity)this, 32.0);
                    if (!(player == null || player.isCreative() || player.isSpectator() || SupernaturalManager.isVampire((LivingEntity)player))) {
                        if (player.isCloseEnough((Entity)this, 1.0)) {
                            if (player.isAlive()) {
                                this.getEntityData().set(POSE, (Object)0);
                                player.hurt(this.damageSources().mobAttack((LivingEntity)this), 6.0f);
                            } else {
                                this.getEntityData().set(POSE, (Object)7);
                            }
                        } else {
                            this.getEntityData().set(POSE, (Object)3);
                            int i = 0;
                            List list = lvl.getPlayers(LivingEntity::isAlive);
                            for (ServerPlayer ply : list) {
                                if (!SupernaturalManager.isVampire((LivingEntity)ply)) {
                                    i = this.isLookingAtMe((Player)ply) ? ++i : --i;
                                }
                                if (i <= 0) {
                                    this.getNavigation().moveTo((Entity)player, 1.25);
                                    continue;
                                }
                                this.getNavigation().stop();
                            }
                        }
                    } else {
                        this.getEntityData().set(POSE, (Object)3);
                    }
                } else if (((Boolean)SupernaturalConfig.FURIA.get()).booleanValue()) {
                    for (Mob target : this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(12.0))) {
                        if (target instanceof Vex) {
                            Vex ghost = (Vex)target;
                            ghost.setLimitedLife(0);
                            continue;
                        }
                        if (!target.getType().is(EntityTypeTags.UNDEAD) || target.isOnFire() || target.fireImmune()) continue;
                        target.setRemainingFireTicks(120);
                    }
                }
            }
        }
    }

    public void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.STONE_STEP, 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)SupernaturalItems.ANGEL_STATUE.get());
    }

    protected void doPush(Entity target) {
    }

    protected void pushEntities() {
    }

    protected boolean shouldDespawnInPeaceful() {
        return this.isCursed();
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canCollideWith(Entity target) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public int getAngelPose() {
        return (Integer)this.getEntityData().get(POSE);
    }

    public boolean isLookingAtMe(Player player) {
        Vec3 view = player.getViewVector(1.0f).normalize();
        Vec3 dis = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double length = dis.length();
        double circle = view.dot(dis = dis.normalize());
        return circle > 5.0E-4 / length && player.hasLineOfSight((Entity)this);
    }

    public boolean isCursed() {
        return (Boolean)this.getEntityData().get(CURSED);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.STEP_HEIGHT, 1.25);
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            lvl.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), this.getX(), this.getY(0.35), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }
}

