/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.supernatural.entity.AbstractMinionEntity;
import net.salju.supernatural.entity.ai.targets.MinionAttackSelector;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalSounds;

public class PossessedArmor
extends AbstractMinionEntity {
    public PossessedArmor(EntityType<PossessedArmor> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (Predicate)new MinionAttackSelector(this)));
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SupernaturalSounds.ARMOR_HURT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)SupernaturalSounds.ARMOR_DEATH.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL) || source.is(DamageTypes.CACTUS) || source.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void dropCustomDeathLoot(ServerLevel lvl, DamageSource src, boolean check) {
        this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (this.getItemBySlot(slot).isEmpty()) continue;
            this.spawnAtLocation(this.getItemBySlot(slot));
            this.setItemSlot(slot, ItemStack.EMPTY);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        this.populateDefaultEquipmentSlots(world.getRandom(), difficulty);
        this.addEffect(new MobEffectInstance(SupernaturalEffects.POSSESSION, Integer.MAX_VALUE, 0));
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SupernaturalItems.GOTHIC_IRON_HELMET.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.IRON_CHESTPLATE));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.IRON_LEGGINGS));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.IRON_BOOTS));
    }

    public void baseTick() {
        super.baseTick();
        if (!this.hasEffect((Holder)SupernaturalEffects.POSSESSION) || !SupernaturalManager.hasArmor((LivingEntity)this)) {
            this.kill();
        }
        if (this.isAlive() && this.isTamed() && this.getEffect((Holder)SupernaturalEffects.POSSESSION).getDuration() <= 10) {
            this.addEffect(new MobEffectInstance(SupernaturalEffects.POSSESSION, Integer.MAX_VALUE, 0));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.MOVEMENT_SPEED, 0.25);
    }
}

