/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.salju.supernatural.entity.ai.spells.AbstractSupernaturalSpellGoal;

public class SupernaturalSummonVexSpellGoal
extends AbstractSupernaturalSpellGoal {
    private final TargetingConditions vexCountTargeting = TargetingConditions.forCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final Random rng = new Random();
    private final Monster user;

    public SupernaturalSummonVexSpellGoal(AbstractIllager source) {
        super((Monster)source);
        this.user = source;
    }

    @Override
    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        int i = 0;
        Level level = this.user.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            i = lvl.getNearbyEntities(Vex.class, this.vexCountTargeting, (LivingEntity)this.user, this.user.getBoundingBox().inflate(32.76)).size();
        }
        return this.rng.nextInt(5) + 1 > i;
    }

    @Override
    protected void performSpellCasting() {
        Level level = this.user.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            for (int i = 0; i < 3; ++i) {
                BlockPos pos = this.user.blockPosition().offset(-2 + this.rng.nextInt(5), 1, -2 + this.rng.nextInt(5));
                Vex ghost = (Vex)EntityType.VEX.spawn(lvl, pos, MobSpawnType.MOB_SUMMONED);
                if (ghost == null) continue;
                ghost.setOwner((Mob)this.user);
                ghost.setBoundOrigin(pos);
                ghost.setLimitedLife(Mth.nextInt((RandomSource)ghost.getRandom(), (int)1200, (int)2400));
            }
        }
    }

    @Override
    protected int getCastingTime() {
        return 60;
    }

    @Override
    protected int getCastingInterval() {
        return 460;
    }

    @Override
    protected int getSpell() {
        return 1;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.EVOKER_PREPARE_SUMMON;
    }
}

