/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.init;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.salju.supernatural.client.model.AngelModel;
import net.salju.supernatural.client.model.GothicArmorModel;
import net.salju.supernatural.client.model.GothicKoboldArmorModel;
import net.salju.supernatural.client.model.PossessedModel;
import net.salju.supernatural.client.model.SpiritModel;
import net.salju.supernatural.client.renderer.AngelRenderer;
import net.salju.supernatural.client.renderer.NecromancerRenderer;
import net.salju.supernatural.client.renderer.PossessedArmorRenderer;
import net.salju.supernatural.client.renderer.RitualBlockRenderer;
import net.salju.supernatural.client.renderer.SpookyRenderer;
import net.salju.supernatural.client.renderer.VampireRenderer;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.init.SupernaturalTags;
import net.salju.supernatural.item.component.RitualCompassData;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SupernaturalClient {
    public static final ModelLayerLocation ANGEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"angel"), "main");
    public static final ModelLayerLocation SPIRIT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"spirit"), "main");
    public static final ModelLayerLocation POSSESSED = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"possessed"), "main");
    public static final ModelLayerLocation GOTHIC = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"gothic"), "main");
    public static final ModelLayerLocation K_GOTHIC = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"gothic_kobold"), "main");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)SupernaturalItems.COMPASS.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((lvl, stack, target) -> {
            RitualCompassData data = (RitualCompassData)stack.get(SupernaturalData.COMPASS);
            return data != null ? data.getGlobalPos() : null;
        }));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SupernaturalMobs.VAMPIRE.get(), VampireRenderer::new);
        event.registerEntityRenderer((EntityType)SupernaturalMobs.NECROMANCER.get(), NecromancerRenderer::new);
        event.registerEntityRenderer((EntityType)SupernaturalMobs.POSSESSED_ARMOR.get(), PossessedArmorRenderer::new);
        event.registerEntityRenderer((EntityType)SupernaturalMobs.SPOOKY.get(), SpookyRenderer::new);
        event.registerEntityRenderer((EntityType)SupernaturalMobs.ANGEL.get(), AngelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SupernaturalBlocks.RITUAL.get(), RitualBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SPIRIT, SpiritModel::createBodyLayer);
        event.registerLayerDefinition(POSSESSED, PossessedModel::createBodyLayer);
        event.registerLayerDefinition(ANGEL, AngelModel::createBodyLayer);
        event.registerLayerDefinition(GOTHIC, GothicArmorModel::createBodyLayer);
        event.registerLayerDefinition(K_GOTHIC, GothicKoboldArmorModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        IClientItemExtensions armor = new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity target, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> basic) {
                if (target.getType().is(SupernaturalTags.KOBOLD)) {
                    return new GothicKoboldArmorModel(GothicKoboldArmorModel.createBodyLayer().bakeRoot(), stack, slot);
                }
                return new GothicArmorModel(GothicArmorModel.createBodyLayer().bakeRoot(), stack, slot);
            }
        };
        event.registerItem(armor, new Holder[]{SupernaturalItems.GOTHIC_DIAMOND_HELMET, SupernaturalItems.GOTHIC_IRON_HELMET, SupernaturalItems.GOTHIC_GOLDEN_HELMET, SupernaturalItems.GOTHIC_NETHERITE_HELMET});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layer) -> layer > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)0), new ItemLike[]{(ItemLike)SupernaturalItems.GOTHIC_IRON_HELMET.get(), (ItemLike)SupernaturalItems.GOTHIC_DIAMOND_HELMET.get(), (ItemLike)SupernaturalItems.GOTHIC_NETHERITE_HELMET.get(), (ItemLike)SupernaturalItems.GOTHIC_GOLDEN_HELMET.get()});
    }
}

