/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.init;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SupernaturalDamageTypes {
    public static final ResourceKey<DamageType> SUN = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"sun"));
    public static final ResourceKey<DamageType> RITUAL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"ritual"));

    public static DamageSource causeSunDamage(RegistryAccess ra) {
        return new SupernaturalDamage((Holder.Reference<DamageType>)((Registry)ra.registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(SUN));
    }

    public static DamageSource causeRitualDamage(RegistryAccess ra, LivingEntity target) {
        return new SupernaturalDamage((Holder.Reference<DamageType>)((Registry)ra.registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(RITUAL), (Entity)target);
    }

    private static class SupernaturalDamage
    extends DamageSource {
        public SupernaturalDamage(Holder.Reference<DamageType> message) {
            super(message);
        }

        public SupernaturalDamage(Holder.Reference<DamageType> message, Entity src) {
            super(message, src);
        }

        public Component getLocalizedDeathMessage(LivingEntity target) {
            Entity entity;
            String s = "death.attack." + this.getMsgId();
            Object object = entity = this.getDirectEntity() != null ? this.getDirectEntity() : target.getLastHurtByMob();
            if (entity != null) {
                return Component.translatable((String)(s + ".entity"), (Object[])new Object[]{target.getDisplayName(), entity.getDisplayName()});
            }
            return Component.translatable((String)s, (Object[])new Object[]{target.getDisplayName()});
        }
    }
}

