/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.salju.supernatural.entity.Angel;
import net.salju.supernatural.entity.Necromancer;
import net.salju.supernatural.entity.PossessedArmor;
import net.salju.supernatural.entity.Spooky;
import net.salju.supernatural.entity.Vampire;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SupernaturalMobs {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"supernatural");
    public static final DeferredHolder<EntityType<?>, EntityType<Vampire>> VAMPIRE = SupernaturalMobs.register("vampire", EntityType.Builder.of(Vampire::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).ridingOffset(-0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<Necromancer>> NECROMANCER = SupernaturalMobs.register("necromancer", EntityType.Builder.of(Necromancer::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).ridingOffset(-0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<PossessedArmor>> POSSESSED_ARMOR = SupernaturalMobs.register("possessed_armor", EntityType.Builder.of(PossessedArmor::new, (MobCategory)MobCategory.MISC).sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<Spooky>> SPOOKY = SupernaturalMobs.register("spooky", EntityType.Builder.of(Spooky::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.75f).eyeHeight(0.52f));
    public static final DeferredHolder<EntityType<?>, EntityType<Angel>> ANGEL = SupernaturalMobs.register("angel", EntityType.Builder.of(Angel::new, (MobCategory)MobCategory.MISC).sized(0.6f, 1.95f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.Builder<T> builder) {
        return REGISTRY.register(name, () -> builder.build(name));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VAMPIRE.get(), Vampire.createAttributes().build());
        event.put((EntityType)NECROMANCER.get(), Necromancer.createAttributes().build());
        event.put((EntityType)POSSESSED_ARMOR.get(), PossessedArmor.createAttributes().build());
        event.put((EntityType)SPOOKY.get(), Spooky.createAttributes().build());
        event.put((EntityType)ANGEL.get(), Angel.createAttributes().build());
    }
}

