/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import destiny.armoryofdestiny.server.block.blockentity.ArmorersTinkeringTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ArmorersTinkeringTableRenderer
implements BlockEntityRenderer<ArmorersTinkeringTableBlockEntity> {
    public ArmorersTinkeringTableRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(ArmorersTinkeringTableBlockEntity table, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)table.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        Level level = table.m_58904_();
        if (table.getBlueprintItem() != ItemStack.f_41583_) {
            if (table.getInputItem() != ItemStack.f_41583_) {
                ItemStack currentItem = table.getInputItem();
                poseStack.m_85836_();
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                boolean isBlockItem = itemRenderer.m_174264_(currentItem, table.m_58904_(), null, 0).applyTransform(ItemDisplayContext.FIXED, poseStack, false).m_7539_();
                poseStack.m_85849_();
                if (isBlockItem) {
                    this.renderLyingBlock(level, poseStack, currentItem, bufferIn, combinedLightIn, direction, table);
                } else {
                    this.renderLyingItem(level, poseStack, currentItem, bufferIn, combinedLightIn, direction, table);
                }
            }
            if (table.getWantStack() != ItemStack.f_41583_ && table.getInputItem().m_41619_()) {
                ItemStack wantItem = table.getWantStack();
                this.renderSpinningItem(level, wantItem, poseStack, partialTicks, bufferIn, combinedLightIn);
            }
        } else if (table.getInputItem() != ItemStack.f_41583_) {
            ItemStack resultItem = table.getInputItem();
            this.renderSpinningItem(level, resultItem, poseStack, partialTicks, bufferIn, combinedLightIn);
        }
        if (table.getHammerSlot() != ItemStack.f_41583_) {
            ItemStack hammer = table.getHammerSlot();
            this.renderHungHammer(level, poseStack, hammer, bufferIn, combinedLightIn, direction, table);
        }
    }

    private void renderSpinningItem(Level level, ItemStack stack, PoseStack poseStack, float partialTicks, MultiBufferSource bufferIn, int combinedLightIn) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        float time = ((float)level.m_46467_() + partialTicks) * 0.8f;
        float yOffset = Mth.m_14031_((float)(time * 0.05f)) * 0.1f + 0.25f;
        poseStack.m_85837_(0.5, (double)(1.0f + yOffset), 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(time * 0.1f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }

    private void renderLyingItem(Level level, PoseStack poseStack, ItemStack stack, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersTinkeringTableBlockEntity table) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (direction == Direction.NORTH) {
            poseStack.m_85837_(0.5, 1.025, 0.375);
        } else if (direction == Direction.SOUTH) {
            poseStack.m_85837_(0.5, 1.025, 0.625);
        } else if (direction == Direction.WEST) {
            poseStack.m_85837_(0.375, 1.025, 0.5);
        } else {
            poseStack.m_85837_(0.625, 1.025, 0.5);
        }
        float f = -direction.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }

    private void renderLyingBlock(Level level, PoseStack poseStack, ItemStack stack, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersTinkeringTableBlockEntity table) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.95, 0.5);
        float f = -direction.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }

    private void renderHungHammer(Level level, PoseStack poseStack, ItemStack hammer, MultiBufferSource bufferIn, int combinedLightIn, Direction direction, ArmorersTinkeringTableBlockEntity table) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (direction == Direction.NORTH) {
            poseStack.m_85837_(0.4325, 0.72, -0.025);
        } else if (direction == Direction.SOUTH) {
            poseStack.m_85837_(0.5675, 0.72, 1.025);
        } else if (direction == Direction.WEST) {
            poseStack.m_85837_(-0.025, 0.72, 0.4325);
        } else {
            poseStack.m_85837_(1.025, 0.72, 0.5675);
        }
        float f = direction.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        itemRenderer.m_269128_(hammer, ItemDisplayContext.GROUND, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
        poseStack.m_85849_();
    }
}

