/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.compat.jei;

import destiny.armoryofdestiny.compat.jei.BloomingCategory;
import destiny.armoryofdestiny.compat.jei.SmithingCategory;
import destiny.armoryofdestiny.compat.jei.SuperheatedBloomingCategory;
import destiny.armoryofdestiny.compat.jei.TemperingCategory;
import destiny.armoryofdestiny.compat.jei.TinkeringCategory;
import destiny.armoryofdestiny.server.recipe.BloomingRecipe;
import destiny.armoryofdestiny.server.recipe.SmithingRecipe;
import destiny.armoryofdestiny.server.recipe.SuperheatedBloomingRecipe;
import destiny.armoryofdestiny.server.recipe.TemperingRecipe;
import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ArmoryOfDestinyJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_LOCATION = new ResourceLocation("armoryofdestiny", "jei_plugin");
    private static Minecraft minecraft = Minecraft.m_91087_();

    public ResourceLocation getPluginUid() {
        return PLUGIN_LOCATION;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BloomingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SuperheatedBloomingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TemperingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmithingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TinkeringCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.BLOOMERY_TOP.get()), new RecipeType[]{BloomingCategory.BLOOMING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.NETHER_BLOOMERY_TOP.get()), new RecipeType[]{SuperheatedBloomingCategory.SUPERHEATED_BLOOMING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.TEMPERING_BARREL.get()), new RecipeType[]{TemperingCategory.TEMPERING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ARMORERS_ANVIL.get()), new RecipeType[]{SmithingCategory.SMITHING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ARMORERS_TINKERING_TABLE.get()), new RecipeType[]{TinkeringCategory.TINKERING_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(ArmoryOfDestinyJEIPlugin.minecraft.f_91073_).m_7465_();
        List bloomingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)BloomingRecipe.Type.INSTANCE);
        List superheatedBloomingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)SuperheatedBloomingRecipe.Type.INSTANCE);
        List temperingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TemperingRecipe.Type.INSTANCE);
        List smithingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)SmithingRecipe.Type.INSTANCE);
        List tinkeringRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TinkeringRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(BloomingCategory.RECIPE_ID, BloomingRecipe.class), bloomingRecipes);
        registration.addRecipes(new RecipeType(SuperheatedBloomingCategory.RECIPE_ID, SuperheatedBloomingRecipe.class), superheatedBloomingRecipes);
        registration.addRecipes(new RecipeType(TemperingCategory.RECIPE_ID, TemperingRecipe.class), temperingRecipes);
        registration.addRecipes(new RecipeType(SmithingCategory.RECIPE_ID, SmithingRecipe.class), smithingRecipes);
        registration.addRecipes(new RecipeType(TinkeringCategory.RECIPE_ID, TinkeringRecipe.class), tinkeringRecipes);
    }
}

