/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.compat.jei;

import destiny.armoryofdestiny.server.recipe.BloomingRecipe;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BloomingCategory
implements IRecipeCategory<BloomingRecipe> {
    public static final ResourceLocation RECIPE_ID = new ResourceLocation("armoryofdestiny", "blooming");
    public static final ResourceLocation TEXTURE = new ResourceLocation("armoryofdestiny", "textures/gui/jei_blooming.png");
    public static final RecipeType<BloomingRecipe> BLOOMING_TYPE = new RecipeType(RECIPE_ID, BloomingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public BloomingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 78, 77);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.BLOOMERY_TOP.get()));
    }

    public RecipeType<BloomingRecipe> getRecipeType() {
        return BLOOMING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.armoryofdestiny.blooming");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BloomingRecipe recipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 23).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 23).addItemStack(recipe.getResult());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, BloomingRecipe recipe, IFocusGroup focuses) {
        this.addCookTime(builder, recipe);
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, BloomingRecipe recipe) {
        int cookTime = recipe.getMeltTime();
        if (cookTime <= 0) {
            cookTime = 0;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 41, 16).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }
}

