/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.compat.jei;

import destiny.armoryofdestiny.server.recipe.SmithingRecipe;
import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.util.ModUtil;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SmithingCategory
implements IRecipeCategory<SmithingRecipe> {
    public static final ResourceLocation RECIPE_ID = new ResourceLocation("armoryofdestiny", "smithing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("armoryofdestiny", "textures/gui/jei_smithing.png");
    public static final RecipeType<SmithingRecipe> SMITHING_TYPE = new RecipeType(RECIPE_ID, SmithingRecipe.class);
    private static Minecraft minecraft = Minecraft.m_91087_();
    private final IDrawable background;
    private final IDrawable icon;

    public SmithingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 193);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.ARMORERS_ANVIL.get()));
    }

    public RecipeType<SmithingRecipe> getRecipeType() {
        return SMITHING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.armoryofdestiny.smithing");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmithingRecipe recipe, IFocusGroup iFocusGroup) {
        this.renderBlueprint(builder, recipe);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 174).addItemStack(recipe.getResult());
        NonNullList<Ingredient> ingredientList = recipe.m_7527_();
        for (int i = 0; i < ingredientList.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 35, 136 - i * 19).addItemStack(((Ingredient)ingredientList.get(i)).m_43908_()[0]);
        }
    }

    private void renderBlueprint(IRecipeLayoutBuilder builder, SmithingRecipe recipe) {
        Object t;
        RecipeManager recipeManager = Objects.requireNonNull(SmithingCategory.minecraft.f_91073_).m_7465_();
        ItemStack parentStack = recipe.getParentItem();
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)parentStack.m_41720_()).toString();
        ResourceLocation blueprintRecipeID = ModUtil.stitchResourceLocationFromItem(itemKey, "tinkering/");
        TinkeringRecipe craftingRecipe = null;
        Optional optionalRecipe = recipeManager.m_44043_(blueprintRecipeID);
        if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof TinkeringRecipe) {
            TinkeringRecipe tinkeringRecipe;
            craftingRecipe = tinkeringRecipe = (TinkeringRecipe)t;
        }
        if (craftingRecipe == null) {
            return;
        }
        ItemStack blueprint = new ItemStack((ItemLike)ItemRegistry.BLUEPRINT.get());
        blueprint.m_41784_().m_128359_("recipe", blueprintRecipeID.toString());
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 155).addItemStack(blueprint);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, SmithingRecipe recipe, IFocusGroup focuses) {
        this.addCookTime(builder, recipe);
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, SmithingRecipe recipe) {
        int hits = recipe.getHammerHits();
        if (hits <= 0) {
            hits = 0;
        }
        if (hits > 0) {
            MutableComponent timeString = Component.m_237113_((String)(hits + " ")).m_7220_((Component)Component.m_237115_((String)"jei.armoryofdestiny.smithing.hits"));
            ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.LEFT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }
}

