/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.compat.jei;

import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.registry.BlockRegistry;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.util.ModUtil;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TinkeringCategory
implements IRecipeCategory<TinkeringRecipe> {
    public static final ResourceLocation RECIPE_ID = new ResourceLocation("armoryofdestiny", "tinkering");
    public static final ResourceLocation TEXTURE = new ResourceLocation("armoryofdestiny", "textures/gui/jei_tinkering.png");
    public static final RecipeType<TinkeringRecipe> TINKERING_TYPE = new RecipeType(RECIPE_ID, TinkeringRecipe.class);
    private static Minecraft minecraft = Minecraft.m_91087_();
    private final IDrawable background;
    private final IDrawable icon;

    public TinkeringCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 90, 93);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.ARMORERS_TINKERING_TABLE.get()));
    }

    public RecipeType<TinkeringRecipe> getRecipeType() {
        return TINKERING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.armoryofdestiny.tinkering");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TinkeringRecipe recipe, IFocusGroup iFocusGroup) {
        this.renderBlueprint(builder, recipe);
        NonNullList<Ingredient> ingredientList = recipe.m_7527_();
        for (int i = 0; i < ingredientList.size(); ++i) {
            int x = 3 + i % 4 * 19;
            int y = 3 + i / 4 * 19;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((Ingredient)ingredientList.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 73).addItemStack(recipe.getResult());
    }

    private void renderBlueprint(IRecipeLayoutBuilder builder, TinkeringRecipe recipe) {
        Object t;
        RecipeManager recipeManager = Objects.requireNonNull(TinkeringCategory.minecraft.f_91073_).m_7465_();
        ItemStack result = recipe.getResult();
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()).toString();
        ResourceLocation blueprintRecipeID = ModUtil.stitchResourceLocationFromItem(itemKey, "tinkering/");
        TinkeringRecipe craftingRecipe = null;
        Optional optionalRecipe = recipeManager.m_44043_(blueprintRecipeID);
        if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof TinkeringRecipe) {
            TinkeringRecipe tinkeringRecipe;
            craftingRecipe = tinkeringRecipe = (TinkeringRecipe)t;
        }
        if (craftingRecipe == null) {
            return;
        }
        ItemStack blueprint = new ItemStack((ItemLike)ItemRegistry.BLUEPRINT.get());
        blueprint.m_41784_().m_128359_("recipe", blueprintRecipeID.toString());
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 41).addItemStack(blueprint);
    }
}

