/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item;

import destiny.armoryofdestiny.server.item.utility.TooltipItem;
import destiny.armoryofdestiny.server.recipe.SmithingRecipe;
import destiny.armoryofdestiny.server.recipe.TinkeringRecipe;
import destiny.armoryofdestiny.server.util.ModUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BlueprintItem
extends TooltipItem {
    public static final String RECIPE = "recipe";

    public BlueprintItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.blueprint";
    }

    @Override
    public boolean hasAbilities() {
        return false;
    }

    public int getRecipeColor(ItemStack stack) {
        Object t;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ResourceLocation recipeKey = this.getRecipeKey(stack);
        if (level == null || recipeKey == null) {
            return 0xFFFFFF;
        }
        Optional recipeOptional = level.m_7465_().m_44043_(recipeKey);
        if (recipeOptional.isPresent() && (t = recipeOptional.get()) instanceof TinkeringRecipe) {
            TinkeringRecipe recipe = (TinkeringRecipe)t;
            return recipe.getBlueprintColor();
        }
        return 0xFFFFFF;
    }

    @Nullable
    public ResourceLocation getRecipeKey(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(RECIPE)) {
            String recipeString = stack.m_41783_().m_128461_(RECIPE);
            ResourceLocation recipeKey = ResourceLocation.m_135820_((String)recipeString);
            return recipeKey;
        }
        return null;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        Object t;
        super.m_7373_(stack, level, components, flag);
        if (level == null) {
            return;
        }
        ResourceLocation recipeID = ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_(RECIPE));
        TinkeringRecipe craftingRecipe = null;
        Optional optionalRecipe = level.m_7465_().m_44043_(recipeID);
        if (optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof TinkeringRecipe) {
            TinkeringRecipe recipe;
            craftingRecipe = recipe = (TinkeringRecipe)t;
        }
        if (craftingRecipe == null) {
            return;
        }
        List<Ingredient> ingredientList = craftingRecipe.getIngredientList();
        ItemStack result = craftingRecipe.getResult();
        MutableComponent blueprint_item_title = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)"item.armoryofdestiny.blueprint.item").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237115_((String)result.m_41778_()).m_130940_(ChatFormatting.RED));
        components.add((Component)blueprint_item_title);
        if (!this.isShift()) {
            MutableComponent blueprint_ingredients_collapsed = Component.m_237115_((String)"tooltip.armoryofdestiny.collapsed").m_7220_((Component)Component.m_237115_((String)"tooltip.armoryofdestiny.ability.collapsed").m_130940_(ChatFormatting.GRAY));
            components.add((Component)blueprint_ingredients_collapsed);
        } else {
            MutableComponent blueprint_ingredients_expanded = Component.m_237115_((String)"tooltip.armoryofdestiny.expanded").m_7220_((Component)Component.m_237115_((String)"item.armoryofdestiny.blueprint.ingredients").m_130940_(ChatFormatting.GRAY));
            components.add((Component)blueprint_ingredients_expanded);
            for (int i = 0; ingredientList.size() > i; ++i) {
                Object t2;
                MutableComponent blueprint_ingredient = Component.m_237115_((String)"tooltip.armoryofdestiny.bullet_point").m_7220_((Component)Component.m_237115_((String)ingredientList.get(i).m_43908_()[0].m_41778_()).m_130940_(ChatFormatting.GRAY));
                components.add((Component)blueprint_ingredient);
                String itemKey = ForgeRegistries.ITEMS.getKey((Object)ingredientList.get(i).m_43908_()[0].m_41720_()).toString();
                ResourceLocation recipeIDMaterial = ModUtil.stitchResourceLocationFromItem(itemKey, "smithing/hot_");
                SmithingRecipe craftingRecipeMaterial = null;
                Optional craftingRecipeMaterialOptional = level.m_7465_().m_44043_(recipeIDMaterial);
                if (craftingRecipeMaterialOptional.isPresent() && (t2 = craftingRecipeMaterialOptional.get()) instanceof SmithingRecipe) {
                    SmithingRecipe recipeMaterial;
                    craftingRecipeMaterial = recipeMaterial = (SmithingRecipe)t2;
                }
                if (craftingRecipeMaterial == null) {
                    return;
                }
                List<Ingredient> ingredientListMaterial = craftingRecipeMaterial.getIngredientList();
                for (int ii = 0; ingredientListMaterial.size() > ii; ++ii) {
                    MutableComponent material_ingredient = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)ingredientListMaterial.get(ii).m_43908_()[0].m_41778_()).m_130940_(ChatFormatting.DARK_GRAY));
                    components.add((Component)material_ingredient);
                }
            }
        }
    }
}

