/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item;

import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.WingedVengeanceRenderer;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class WingedVengeanceItem
extends ArmorItem
implements GeoItem {
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlayAndHold("idle");
    private static final RawAnimation FLYING = RawAnimation.begin().thenLoop("flying");
    private static Boolean isFlying = false;
    private static Boolean isIdle = false;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public WingedVengeanceItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WingedVengeanceRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "armoryofdestiny:textures/item/armor/winged_vengeance.png";
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, state -> PlayState.CONTINUE).triggerableAnim("idle", IDLE).triggerableAnim("flying", FLYING)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean b) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == this) {
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
            } else if (!player.m_7500_() && !player.m_5833_()) {
                player.m_150110_().f_35935_ = false;
                player.m_150110_().f_35936_ = false;
                player.m_6885_();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player.m_150110_().f_35935_ && !isFlying.booleanValue()) {
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "flying");
                    isFlying = true;
                    isIdle = false;
                    System.out.println("Flying animation triggered");
                } else if (!player.m_150110_().f_35935_ && !isIdle.booleanValue()) {
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "idle");
                    isIdle = true;
                    isFlying = false;
                    System.out.println("Idle animation triggered");
                }
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return super.m_7167_(p_40390_);
    }
}

