/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.CrucibleItemRenderer;
import destiny.armoryofdestiny.server.item.utility.TooltipSwordItem;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrucibleItem
extends TooltipSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String USAGES = "usages";
    private float attackDamage = 29.0f;
    private double attackSpeed = -2.5;
    private double attackKnockback = -1.5;
    private double entityReach = 1.0;

    public CrucibleItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackKnockback, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.entityReach, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private CrucibleItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new CrucibleItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.CRUCIBLE_INACTIVE.get());
        if (stack.m_41783_() != null) {
            newStack.m_41784_().m_128391_(stack.m_41783_());
        }
        player.m_21008_(hand, newStack);
        level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.CRUCIBLE_DEACTIVATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36335_().m_41524_(newStack.m_41720_(), 20);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity1, LivingEntity entity2) {
        if (stack.m_41783_() != null) {
            int usages = stack.m_41783_().m_128451_(USAGES);
            if (3 >= usages && usages > 1) {
                stack.m_41622_(1, entity2, entity3 -> entity3.m_21166_(EquipmentSlot.MAINHAND));
                stack.m_41784_().m_128405_(USAGES, usages - 1);
                entity1.m_5496_((SoundEvent)SoundRegistry.CRUCIBLE_SWING.get(), 1.0f, 1.0f);
                return true;
            }
            if (usages == 1) {
                stack.m_41622_(1, entity2, entity3 -> entity3.m_21166_(EquipmentSlot.MAINHAND));
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.CRUCIBLE_INACTIVE.get(), 1);
                    stack.m_41784_().m_128405_(USAGES, 0);
                    if (stack.m_41783_() != null) {
                        newStack.m_41784_().m_128391_(stack.m_41783_());
                    }
                    player.m_21008_(InteractionHand.MAIN_HAND, newStack);
                    player.m_36335_().m_41524_(newStack.m_41720_(), 100);
                }
                entity1.m_5496_((SoundEvent)SoundRegistry.CRUCIBLE_SWING.get(), 1.0f, 1.0f);
                entity1.m_5496_((SoundEvent)SoundRegistry.CRUCIBLE_DEACTIVATE.get(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.greatsword";
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.0f, (float)1.0f, (float)0.9f);
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(USAGES) > 0;
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            int usages = stack.m_41783_().m_128451_(USAGES);
            return Math.round((float)usages / 3.0f * 13.0f);
        }
        return 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

