/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.DragonSlayerItemRenderer;
import destiny.armoryofdestiny.server.item.utility.TooltipSwordItem;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonSlayerItem
extends TooltipSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final UUID ABILITY_MULTIPLIER_UUID = UUID.fromString("CB3F55D3-644C-4F38-A497-9C13A23DB6CF");
    public static final String DAMAGE_DEALT = "damageDealt";
    private final float attackDamage;
    private final double attackSpeed;
    private final double attackKnockback;
    private final double entityReach;
    public float attackDamageAbility;
    public int damageDealtCap = 10240;

    public DragonSlayerItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        this.attackDamage = 13.0f;
        this.attackSpeed = -2.8;
        this.attackKnockback = 0.8;
        this.entityReach = 2.0;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DragonSlayerItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DragonSlayerItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.STOP)});
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (stack.m_41783_() != null) {
                int damageDealt = stack.m_41784_().m_128451_(DAMAGE_DEALT);
                this.attackDamageAbility = Math.min(24, 24 * (damageDealt / this.damageDealtCap));
                if (damageDealt > 0) {
                    builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackDamageAbility, AttributeModifier.Operation.ADDITION));
                }
            }
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackKnockback, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.entityReach, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return target.m_20191_().m_82377_(2.0, 0.5, 2.0);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_(Items.f_42418_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.greatsword";
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        if (this.isShift() && stack.m_41783_() != null) {
            MutableComponent damage_total = Component.m_237115_((String)"tooltip.armoryofdestiny.dropdown").m_7220_((Component)Component.m_237115_((String)"item.armoryofdestiny.dragon_slayer.ability.1.damage_total").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("" + stack.m_41783_().m_128451_(DAMAGE_DEALT))).m_130940_(ChatFormatting.DARK_GRAY));
            components.add((Component)damage_total);
        }
    }
}

