/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.MurasamaItemRenderer;
import destiny.armoryofdestiny.server.item.utility.TooltipSwordItem;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MurasamaItem
extends TooltipSwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    boolean played = false;
    private float attackDamage = 11.0f;
    private double attackSpeed = -0.4f;
    private double attackKnockback = -2.6f;
    private int entityReach = 1;
    public static final String ABILITY_TICK = "abilityTick";
    public static final UUID ABILITY_MULTIPLIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A23DB6CF");
    public float attackDamageAbility = 12.0f;
    public float attackSpeedAbility = 3.6f;
    public float attackKnockbackAbility = 1.4f;

    public MurasamaItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MurasamaItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MurasamaItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, state -> PlayState.STOP)});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21206_().m_41720_() == ItemRegistry.GUN_SHEATH.get()) {
            player.m_21206_().m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)ItemRegistry.MURASAMA_SHEATHED.get()));
            if (stack.m_41783_() != null) {
                player.m_21205_().m_41784_().m_128391_(stack.m_41783_());
            }
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_(player.m_21120_(hand).m_41720_(), 40);
            }
            level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.MURASAMA_SHEATH.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.MURASAMA_INSERT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (stack.m_41783_() != null && stack.m_41784_().m_128451_(ABILITY_TICK) > 0) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackDamageAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackSpeedAbility, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ABILITY_MULTIPLIER_UUID, "Active ability", (double)this.attackKnockbackAbility, AttributeModifier.Operation.ADDITION));
            }
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackKnockback, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.entityReach, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity1, LivingEntity entity2) {
        stack.m_41622_(1, entity2, entity3 -> entity3.m_21166_(EquipmentSlot.MAINHAND));
        if (stack.m_41783_() != null && stack.m_41784_().m_128451_(ABILITY_TICK) > 0) {
            entity1.m_5496_((SoundEvent)SoundRegistry.MURASAMA_SPECIAL_HIT.get(), 0.5f, 1.0f);
            stack.m_41784_().m_128405_(ABILITY_TICK, 0);
        }
        return true;
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        if (stack.m_41784_().m_128451_(ABILITY_TICK) > 0) {
            return target.m_20191_().m_82377_(2.0, 0.5, 2.0);
        }
        return target.m_20191_().m_82377_(1.0, 0.25, 1.0);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_(Items.f_220224_);
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.katana";
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean b) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41783_() != null) {
                int abilityTick = stack.m_41784_().m_128451_(ABILITY_TICK);
                if (abilityTick > 0 && abilityTick < 20) {
                    stack.m_41784_().m_128405_(ABILITY_TICK, abilityTick + 1);
                } else if (abilityTick == 20) {
                    stack.m_41784_().m_128405_(ABILITY_TICK, 0);
                }
            }
        }
    }
}

