/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import destiny.armoryofdestiny.client.render.item.SharpIronyItemRenderer;
import destiny.armoryofdestiny.server.entity.MetallicFeatherEntity;
import destiny.armoryofdestiny.server.item.utility.TooltipSwordItem;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import destiny.armoryofdestiny.server.registry.SoundRegistry;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SharpIronyItem
extends TooltipSwordItem
implements GeoItem {
    private static final RawAnimation SHARP_IRONY_OPEN = RawAnimation.begin().thenPlay("sharp_irony.open");
    private static final RawAnimation SHARP_IRONY_CLOSE = RawAnimation.begin().thenPlay("sharp_irony.close");
    private static final RawAnimation SHARP_IRONY_THROW = RawAnimation.begin().thenPlay("sharp_irony.throw");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String AMMO_COUNT = "ammoCount";
    public static final String IS_OPEN = "isOpen";
    public static final Predicate<ItemStack> IS_METALLIC_FEATHER = stack -> stack.m_41720_() == ItemRegistry.METALLIC_FEATHER.get();
    private float attackDamage = 5.0f;
    private double attackSpeed = -0.4f;

    public SharpIronyItem(Item.Properties build) {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, build);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private SharpIronyItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SharpIronyItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sharp_irony_controller", 0, state -> PlayState.STOP).triggerableAnim("open", SHARP_IRONY_OPEN).triggerableAnim("close", SHARP_IRONY_CLOSE).triggerableAnim("throw", SHARP_IRONY_THROW)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_41783_() == null || stack.m_41783_().m_128423_(AMMO_COUNT) == null) {
            stack.m_41784_().m_128379_(IS_OPEN, false);
            stack.m_41784_().m_128405_(AMMO_COUNT, 5);
        }
        boolean isOpen = stack.m_41784_().m_128471_(IS_OPEN);
        int ammoCount = this.getFanAmmo(stack);
        if (isOpen) {
            if (this.isControl()) {
                this.throwAll(level, player, stack, item, hand);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            if (this.isShift()) {
                this.closeFan(level, player, stack, item);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (ammoCount > 0) {
                this.throwFeather(level, player, stack, item, hand, player.m_146909_(), player.m_146908_());
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            if (this.getAmmoCount(player) > 0) {
                this.reload(level, player, stack, item);
            }
        } else if (ammoCount < 5 && this.getAmmoCount(player) > 0) {
            this.reload(level, player, stack, item);
        } else {
            this.openFan(level, player, stack, item);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void throwFeather(Level level, Player player, ItemStack stack, Item item, InteractionHand hand, float XRot, float YRot) {
        int ammoCount = stack.m_41784_().m_128451_(AMMO_COUNT);
        if (!level.f_46443_) {
            MetallicFeatherEntity feather = new MetallicFeatherEntity(level, (LivingEntity)player);
            feather.m_37251_((Entity)player, XRot, YRot, 0.0f, 5.0f, 1.0f);
            level.m_7967_((Entity)feather);
        }
        stack.m_41784_().m_128405_(AMMO_COUNT, ammoCount - 1);
        if (!player.m_7500_()) {
            stack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
        }
        this.triggerAnim(level, player, stack, "sharp_irony_controller", "throw");
        level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.SHARP_IRONY_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36335_().m_41524_(item, 5);
    }

    public void throwAll(Level level, Player player, ItemStack stack, Item item, InteractionHand hand) {
        int ammoCount = stack.m_41784_().m_128451_(AMMO_COUNT);
        if (ammoCount > 0) {
            float YRot = ammoCount % 2 == 0 ? player.m_146908_() - (float)(ammoCount * 5) / 2.0f + 2.5f : player.m_146908_() - (float)(ammoCount * 5) / 2.0f;
            for (int i = 0; i < ammoCount; ++i) {
                this.throwFeather(level, player, stack, item, hand, player.m_146909_(), YRot);
                YRot += 5.0f;
            }
            stack.m_41784_().m_128405_(AMMO_COUNT, 0);
            level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.SHARP_IRONY_THROW_SPECIAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.triggerAnim(level, player, stack, "sharp_irony_controller", "throw");
            player.m_36335_().m_41524_(item, 30);
        }
    }

    public void reload(Level level, Player player, ItemStack stack, Item item) {
        int ammoCount = this.getFanAmmo(stack);
        if (ammoCount < 5) {
            ItemStack feather_stack = this.findAmmo(player);
            int feather_stack_amount = this.getAmmoCount(player);
            if (feather_stack_amount > 0) {
                if (!player.m_7500_()) {
                    if (5 >= feather_stack_amount + ammoCount) {
                        feather_stack.m_41774_(feather_stack_amount);
                        stack.m_41784_().m_128405_(AMMO_COUNT, ammoCount + feather_stack_amount);
                    } else if (5 < feather_stack_amount + ammoCount) {
                        feather_stack.m_41774_(5 - ammoCount);
                        stack.m_41784_().m_128405_(AMMO_COUNT, ammoCount + 5 - ammoCount);
                    }
                } else {
                    stack.m_41784_().m_128405_(AMMO_COUNT, 5);
                }
            }
            this.openFan(level, player, stack, item);
        }
    }

    public int getFanAmmo(ItemStack stack) {
        return stack.m_41784_().m_128451_(AMMO_COUNT);
    }

    public void openFan(Level level, Player player, ItemStack stack, Item item) {
        stack.m_41784_().m_128379_(IS_OPEN, true);
        this.triggerAnim(level, player, stack, "sharp_irony_controller", "open");
        level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.SHARP_IRONY_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36335_().m_41524_(item, 5);
    }

    public void closeFan(Level level, Player player, ItemStack stack, Item item) {
        stack.m_41784_().m_128379_(IS_OPEN, false);
        this.triggerAnim(level, player, stack, "sharp_irony_controller", "close");
        level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.SHARP_IRONY_CLOSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36335_().m_41524_(item, 5);
    }

    public ItemStack findAmmo(Player player) {
        if (player.m_7500_()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack ammo_item = player.m_150109_().m_8020_(i);
            if (!IS_METALLIC_FEATHER.test(ammo_item)) continue;
            return ammo_item;
        }
        return ItemStack.f_41583_;
    }

    public int getAmmoCount(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack ammo_item = player.m_150109_().m_8020_(i);
            int ammo_number = player.m_150109_().m_8020_(i).m_41613_();
            if (!IS_METALLIC_FEATHER.test(ammo_item)) continue;
            return ammo_number;
        }
        return 0;
    }

    public void triggerAnim(Level level, Player player, ItemStack stack, String controller, String name) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), controller, name);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_(Items.f_42419_);
    }

    @Override
    public String getTriviaTranslatable() {
        return "tooltip.armoryofdestiny.trivia.throwing_fan";
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (stack.m_41783_() != null && selected && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41784_().m_128471_(IS_OPEN)) {
                this.triggerAnim(level, player, stack, "sharp_irony_controller", "open");
            } else {
                this.triggerAnim(level, player, stack, "sharp_irony_controller", "close");
            }
        }
    }
}

