/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import destiny.armoryofdestiny.server.registry.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class BlueprintLootModifier
implements IGlobalLootModifier {
    private static final MapCodec<ResourceLocation> ENTRY_CODEC = ResourceLocation.f_135803_.fieldOf("recipeID");
    public static final Supplier<Codec<BlueprintLootModifier>> CODEC = () -> RecordCodecBuilder.create(inst -> inst.group((App)ENTRY_CODEC.forGetter(configuration -> configuration.recipeID), (App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)inst, BlueprintLootModifier::new));
    private final LootItemCondition[] conditions;
    private final Predicate<LootContext> orConditions;
    private final ResourceLocation recipeID;

    public BlueprintLootModifier(ResourceLocation recipeID, LootItemCondition[] conditionsIn) {
        this.recipeID = recipeID;
        this.conditions = conditionsIn;
        this.orConditions = LootItemConditions.m_81841_((Predicate[])conditionsIn);
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.orConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if ((double)context.m_230907_().m_188501_() < 0.15) {
            generatedLoot.add((Object)this.getBlueprint());
        }
        return generatedLoot;
    }

    private ItemStack getBlueprint() {
        CompoundTag tag = new CompoundTag();
        ResourceLocation location = ResourceLocation.m_135820_((String)"");
        if (this.recipeID != null) {
            location = this.recipeID;
        }
        tag.m_128359_("recipe", location.toString());
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.BLUEPRINT.get());
        stack.m_41751_(tag);
        return stack;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

