/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import destiny.armoryofdestiny.server.container.BloomingContainer;
import destiny.armoryofdestiny.server.util.UtilityCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BloomingRecipe
implements Recipe<BloomingContainer> {
    public ResourceLocation recipeID;
    public Ingredient ingredient;
    public int meltTime;
    public ItemStack result;
    public static final Codec<BloomingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UtilityCodecs.INGREDIENT_CODEC.fieldOf("ingredient").forGetter(BloomingRecipe::getIngredient), (App)Codec.INT.fieldOf("melt_time").forGetter(BloomingRecipe::getMeltTime), (App)UtilityCodecs.STACK_CODEC.fieldOf("result").forGetter(BloomingRecipe::getResult)).apply((Applicative)instance, BloomingRecipe::new));

    public BloomingRecipe(Ingredient ingredient, int meltTime, ItemStack result) {
        this.ingredient = ingredient;
        this.meltTime = meltTime;
        this.result = result;
    }

    public BloomingRecipe(ResourceLocation recipeID, Ingredient ingredient, int meltTime, ItemStack result) {
        this.recipeID = recipeID;
        this.ingredient = ingredient;
        this.meltTime = meltTime;
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getMeltTime() {
        return this.meltTime;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean matches(BloomingContainer container, Level level) {
        return this.ingredient.test(container.input);
    }

    public ItemStack assemble(BloomingContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)this.ingredient, (Object[])new Ingredient[0]);
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BloomingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("armoryofdestiny", "blooming");

        public BloomingRecipe fromJson(ResourceLocation recipeID, JsonObject jsonRecipe) {
            BloomingRecipe recipe = (BloomingRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonRecipe).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            return new BloomingRecipe(recipeID, recipe.ingredient, recipe.meltTime, recipe.result);
        }

        @Nullable
        public BloomingRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int meltTime = buffer.readInt();
            ItemStack result = buffer.m_130267_();
            return new BloomingRecipe(recipeID, ingredient, meltTime, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, BloomingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.writeInt(recipe.meltTime);
            buffer.m_130055_(recipe.result);
        }
    }

    public static class Type
    implements RecipeType<BloomingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "blooming";

        private Type() {
        }
    }
}

