/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import destiny.armoryofdestiny.server.container.SmithingContainer;
import destiny.armoryofdestiny.server.util.UtilityCodecs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipe
implements Recipe<SmithingContainer> {
    public ResourceLocation recipeID;
    public ItemStack parentItem;
    public List<Ingredient> ingredients;
    public int hammerHits;
    public ItemStack result;
    public static final Codec<SmithingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UtilityCodecs.STACK_CODEC.fieldOf("parent_item").forGetter(SmithingRecipe::getParentItem), (App)UtilityCodecs.INGREDIENT_CODEC.listOf().fieldOf("ingredients").forGetter(SmithingRecipe::getIngredientList), (App)Codec.INT.fieldOf("hammer_hits").forGetter(SmithingRecipe::getHammerHits), (App)UtilityCodecs.STACK_CODEC.fieldOf("result").forGetter(SmithingRecipe::getResult)).apply((Applicative)instance, SmithingRecipe::new));

    public SmithingRecipe(ItemStack parentItem, List<Ingredient> ingredients, int hammerHits, ItemStack result) {
        this.parentItem = parentItem;
        this.ingredients = ingredients;
        this.hammerHits = hammerHits;
        this.result = result;
    }

    public SmithingRecipe(ResourceLocation recipeID, ItemStack parentItem, List<Ingredient> ingredients, int hammerHits, ItemStack result) {
        this.recipeID = recipeID;
        this.parentItem = parentItem;
        this.ingredients = ingredients;
        this.hammerHits = hammerHits;
        this.result = result;
    }

    public ItemStack getParentItem() {
        return this.parentItem;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getHammerHits() {
        return this.hammerHits;
    }

    public List<Ingredient> getIngredientList() {
        return this.ingredients;
    }

    public boolean matches(SmithingContainer container, Level level) {
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>(this.ingredients);
        ArrayList<ItemStack> storedList = new ArrayList<ItemStack>(container.inputs);
        ArrayList<Boolean> test = new ArrayList<Boolean>();
        if (ingredientList.size() == storedList.size()) {
            for (int i = 0; i < ingredientList.size(); ++i) {
                if (!((Ingredient)ingredientList.get(i)).test((ItemStack)storedList.get(i))) continue;
                test.add(true);
            }
        }
        return test.size() == this.ingredients.size();
    }

    public ItemStack assemble(SmithingContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_182647_((int)this.getIngredientList().size());
        list.addAll(this.getIngredientList());
        return list;
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SmithingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("armoryofdestiny", "smithing");

        public SmithingRecipe fromJson(ResourceLocation recipeID, JsonObject jsonRecipe) {
            SmithingRecipe recipe = (SmithingRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonRecipe).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            return new SmithingRecipe(recipeID, recipe.parentItem, recipe.ingredients, recipe.hammerHits, recipe.result);
        }

        @Nullable
        public SmithingRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            ItemStack parentItem = buffer.m_130267_();
            List stacks = (List)buffer.m_236838_(i -> new ArrayList(), Ingredient::m_43940_);
            int hammerHits = buffer.readInt();
            ItemStack result = buffer.m_130267_();
            return new SmithingRecipe(recipeID, parentItem, stacks, hammerHits, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, SmithingRecipe recipe) {
            buffer.m_130055_(recipe.parentItem);
            buffer.m_236828_(recipe.ingredients, (writeBuffer, ingredient) -> ingredient.m_43923_(writeBuffer));
            buffer.writeInt(recipe.hammerHits);
            buffer.m_130055_(recipe.result);
        }
    }

    public static class Type
    implements RecipeType<SmithingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "smithing";

        private Type() {
        }
    }
}

