/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import destiny.armoryofdestiny.server.container.TemperingContainer;
import destiny.armoryofdestiny.server.util.UtilityCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TemperingRecipe
implements Recipe<TemperingContainer> {
    public ResourceLocation recipeID;
    public Ingredient ingredient;
    public ItemStack result;
    public static final Codec<TemperingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UtilityCodecs.INGREDIENT_CODEC.fieldOf("ingredient").forGetter(TemperingRecipe::getIngredient), (App)UtilityCodecs.STACK_CODEC.fieldOf("result").forGetter(TemperingRecipe::getResult)).apply((Applicative)instance, TemperingRecipe::new));

    public TemperingRecipe(Ingredient ingredient, ItemStack result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    public TemperingRecipe(ResourceLocation recipeID, Ingredient ingredient, ItemStack result) {
        this.recipeID = recipeID;
        this.ingredient = ingredient;
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean matches(TemperingContainer container, Level level) {
        return this.ingredient.test(container.input);
    }

    public ItemStack assemble(TemperingContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)this.ingredient, (Object[])new Ingredient[0]);
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<TemperingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("armoryofdestiny", "tempering");

        public TemperingRecipe fromJson(ResourceLocation recipeID, JsonObject jsonRecipe) {
            TemperingRecipe recipe = (TemperingRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonRecipe).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            return new TemperingRecipe(recipeID, recipe.ingredient, recipe.result);
        }

        @Nullable
        public TemperingRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new TemperingRecipe(recipeID, ingredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, TemperingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }

    public static class Type
    implements RecipeType<TemperingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "tempering";

        private Type() {
        }
    }
}

