/*
 * Decompiled with CFR 0.152.
 */
package destiny.armoryofdestiny.server.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import destiny.armoryofdestiny.server.container.TinkeringContainer;
import destiny.armoryofdestiny.server.util.UtilityCodecs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TinkeringRecipe
implements Recipe<TinkeringContainer> {
    public ResourceLocation recipeID;
    public int color;
    public List<Ingredient> ingredients;
    public ItemStack result;
    public static final Codec<TinkeringRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("blueprint_color").forGetter(TinkeringRecipe::getBlueprintColor), (App)UtilityCodecs.INGREDIENT_CODEC.listOf().fieldOf("ingredients").forGetter(TinkeringRecipe::getIngredientList), (App)UtilityCodecs.STACK_CODEC.fieldOf("result").forGetter(TinkeringRecipe::getResult)).apply((Applicative)instance, TinkeringRecipe::new));

    public TinkeringRecipe(int color, List<Ingredient> ingredients, ItemStack result) {
        this.color = color;
        this.ingredients = ingredients;
        this.result = result;
    }

    public TinkeringRecipe(ResourceLocation recipeID, int color, List<Ingredient> ingredients, ItemStack result) {
        this.recipeID = recipeID;
        this.color = color;
        this.ingredients = ingredients;
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getBlueprintColor() {
        return this.color;
    }

    public List<Ingredient> getIngredientList() {
        return this.ingredients;
    }

    public boolean matches(TinkeringContainer container, Level level) {
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>(this.ingredients);
        ArrayList<ItemStack> storedList = new ArrayList<ItemStack>(container.inputs);
        ArrayList<Boolean> test = new ArrayList<Boolean>();
        Iterator ingredientCopy = ingredientList.iterator();
        block0: while (ingredientCopy.hasNext()) {
            Ingredient ingredient = (Ingredient)ingredientCopy.next();
            for (ItemStack storedItem : storedList) {
                if (!ingredient.test(storedItem)) continue;
                ingredientCopy.remove();
                storedList.remove(storedItem);
                test.add(true);
                continue block0;
            }
        }
        return test.size() == this.ingredients.size();
    }

    public ItemStack assemble(TinkeringContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_182647_((int)this.getIngredientList().size());
        list.addAll(this.getIngredientList());
        return list;
    }

    public ResourceLocation m_6423_() {
        return this.recipeID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<TinkeringRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("armoryofdestiny", "tinkering");

        public TinkeringRecipe fromJson(ResourceLocation recipeID, JsonObject jsonRecipe) {
            TinkeringRecipe recipe = (TinkeringRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonRecipe).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            return new TinkeringRecipe(recipeID, recipe.color, recipe.ingredients, recipe.result);
        }

        @Nullable
        public TinkeringRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int color = buffer.readInt();
            List stacks = (List)buffer.m_236838_(i -> new ArrayList(), Ingredient::m_43940_);
            ItemStack result = buffer.m_130267_();
            return new TinkeringRecipe(recipeID, color, stacks, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, TinkeringRecipe recipe) {
            buffer.writeInt(recipe.color);
            buffer.m_236828_(recipe.ingredients, (writeBuffer, ingredient) -> ingredient.m_43923_(writeBuffer));
            buffer.writeItemStack(recipe.result, false);
        }
    }

    public static class Type
    implements RecipeType<TinkeringRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "tinkering";

        private Type() {
        }
    }
}

