/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client;

import com.jdolphin.ricksportalgun.client.init.PGItemTints;
import com.jdolphin.ricksportalgun.client.init.PGMenuScreens;
import com.jdolphin.ricksportalgun.client.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.client.render.PortalEntityRenderer;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGKeyBinds;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="ricksportalgun")
public class NeoForgeClientMain {
    @SubscribeEvent
    public static void clientSetup(RegisterMenuScreensEvent event) {
        PGMenuScreens.ALL.forEach((type, func) -> {
            MenuScreens.ScreenConstructor constructor = (arg_0, arg_1, arg_2) -> ((TriFunction)func).apply(arg_0, arg_1, arg_2);
            event.register(type, constructor);
        });
    }

    @SubscribeEvent
    public static void registerTints(RegisterColorHandlersEvent.ItemTintSources event) {
        PGItemTints.ALL.forEach((arg_0, arg_1) -> ((RegisterColorHandlersEvent.ItemTintSources)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(PGKeyBinds.KEY_PORTAL_MENU);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PortalEntityModel.LAYER_LOCATION, PortalEntityModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(PGEntities.PORTAL, PortalEntityRenderer::new);
        event.registerEntityRenderer(PGEntities.EXPLOSIVE_ITEM, ItemEntityRenderer::new);
    }

    @EventBusSubscriber(modid="ricksportalgun", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post event) {
            PortalEntityRenderer.tickTexture();
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            LocalPlayer player;
            if (PGKeyBinds.KEY_PORTAL_MENU.consumeClick() && (player = Minecraft.getInstance().player) != null && player.isHolding(stack -> stack.is(PGTags.Items.PORTAL_GUNS))) {
                SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

